﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Cpu.h>
#include <nn/TargetConfigs/build_Fpu.h>
#include <nn/svc/svc_BaseId.autogen.h>
#include <nn/svc/svc_ServerId.autogen.h>
#include <nn/svc/svc_TcbId.autogen.h>

#if defined NN_BUILD_CONFIG_CPU_ARM64
    .section .text, "ax"
    .align   2
    .global  _Z18ClientLightSessionN2nn3svc6HandleE
    .type    _Z18ClientLightSessionN2nn3svc6HandleE, %function
_Z18ClientLightSessionN2nn3svc6HandleE:
    sub     sp, sp, #8*2
    str     x20, [sp]
    mov     x20, x0

    ldr     w1, =0x80000001
    ldr     w2, =0x80000002
    ldr     w3, =0x80000003
    ldr     w4, =0x80000004
    ldr     w5, =0x80000005
    ldr     w6, =0x80000006
    ldr     w7, =0x80000007

    mov     x0, x20
    svc     #NN_SVC_ID_SEND_SYNC_REQUEST_LIGHT

    cmp     x0, #0
    b.ne    1f
    ldr     w0, =0x80000002
    cmp     w1, w0
    b.ne    2f
    cmp     w2, #(2 * 2)
    b.ne    2f
    cmp     w3, #(3 * 2)
    b.ne    2f
    cmp     w4, #(4 * 2)
    b.ne    2f
    cmp     w5, #(5 * 2)
    b.ne    2f
    cmp     w6, #(6 * 2)
    b.ne    2f
    cmp     w7, #(7 * 2)
    b.ne    2f

    mov     x0, x20
    svc     #NN_SVC_ID_SEND_SYNC_REQUEST_LIGHT

    cmp     x0, #0
    b.ne    1f
    ldr     w0, =0x80000004
    cmp     w1, w0
    b.ne    2f
    cmp     w2, #(2 * 4)
    b.ne    2f
    cmp     w3, #(3 * 4)
    b.ne    2f
    cmp     w4, #(4 * 4)
    b.ne    2f
    cmp     w5, #(5 * 4)
    b.ne    2f
    cmp     w6, #(6 * 4)
    b.ne    2f
    cmp     w7, #(7 * 4)

    mov     x0, #0
    b.ne    2f

    ldr     x20, [sp]
    add     sp, sp, #8*2
    ret

1:  mov     x0, #2
    svc     #NN_SVC_ID_BREAK
2:  mov     x0, #2
    svc     #NN_SVC_ID_BREAK
3:  mov     x0, #2
    svc     #NN_SVC_ID_BREAK
4:  mov     x0, #2
    svc     #NN_SVC_ID_BREAK
5:  mov     x0, #2
    svc     #NN_SVC_ID_BREAK
    .size   _Z18ClientLightSessionN2nn3svc6HandleE, [. - _Z18ClientLightSessionN2nn3svc6HandleE]

    .section .text, "ax"
    .align   2
    .global  _Z18ServerLightSessionN2nn3svc6HandleE
    .type    _Z18ServerLightSessionN2nn3svc6HandleE, %function
_Z18ServerLightSessionN2nn3svc6HandleE:
    sub     sp, sp, #8*2
    str     x20, [sp]
    mov     x20, x0

    mov     x1, #0
    mov     x2, #0
    mov     x3, #0
    mov     x4, #0
    mov     x5, #0
    mov     x6, #0
    mov     x7, #0

    mov     x0, x20
    svc     #NN_SVC_ID_REPLY_AND_RECEIVE_LIGHT
    cmp     x0, #0
    b.ne    1f
    ldr     w8, =0x80000001
    cmp     w1, w8
    b.ne    2f
    ldr     w8, =0x80000002
    cmp     w2, w8
    b.ne    2f
    ldr     w8, =0x80000003
    cmp     w3, w8
    b.ne    2f
    ldr     x8, =0x80000004
    cmp     w4, w8
    b.ne    2f
    ldr     w8, =0x80000005
    cmp     w5, w8
    b.ne    2f
    ldr     w8, =0x80000006
    cmp     w6, w8
    b.ne    2f
    ldr     w8, =0x80000007
    cmp     w7, w8
    b.ne    2f

    ldr     w1, =0x80000002
    lsl     w2, w2, #1
    lsl     w3, w3, #1
    lsl     w4, w4, #1
    lsl     w5, w5, #1
    lsl     w6, w6, #1
    lsl     w7, w7, #1

    mov     x0, x20
    svc     #NN_SVC_ID_REPLY_AND_RECEIVE_LIGHT
    cmp     x0, #0
    b.ne    3f
    ldr     w0, =0x80000002
    cmp     w1, w0
    b.ne    4f
    cmp     w2, #(2 * 2)
    b.ne    4f
    cmp     w3, #(3 * 2)
    b.ne    4f
    cmp     w4, #(4 * 2)
    b.ne    4f
    cmp     w5, #(5 * 2)
    b.ne    4f
    cmp     w6, #(6 * 2)
    b.ne    4f
    cmp     w7, #(7 * 2)
    b.ne    4f

    ldr     w1, =0x80000004
    lsl     w2, w2, #1
    lsl     w3, w3, #1
    lsl     w4, w4, #1
    lsl     w5, w5, #1
    lsl     w6, w6, #1
    lsl     w7, w7, #1

    mov     x0, x20
    svc     #NN_SVC_ID_REPLY_AND_RECEIVE_LIGHT
    cmp     x0, #0
    beq     5f

    ldr     x20, [sp]
    add     sp, sp, #8*2
    ret
1:  mov     x0, #2
    svc     #NN_SVC_ID_BREAK
2:  mov     x0, #2
    svc     #NN_SVC_ID_BREAK
3:  mov     x0, #2
    svc     #NN_SVC_ID_BREAK
4:  mov     x0, #2
    svc     #NN_SVC_ID_BREAK
5:  mov     x0, #2
    svc     #NN_SVC_ID_BREAK
    .size   _Z18ServerLightSessionN2nn3svc6HandleE, [. - _Z18ServerLightSessionN2nn3svc6HandleE]

#else
    .section .text, "ax"
    .align   2
    .global  _Z18ClientLightSessionN2nn3svc6HandleE
    .type    _Z18ClientLightSessionN2nn3svc6HandleE, %function
_Z18ClientLightSessionN2nn3svc6HandleE:
    push    {r4-r8, lr}
    mov     r8, r0

    mov     r1, #1
    mov     r2, #2
    mov     r3, #3
    mov     r4, #4
    mov     r5, #5
    mov     r6, #6
    mov     r7, #7

    mov     r0, r8
    svc     #NN_SVC_ID_SEND_SYNC_REQUEST_LIGHT

    cmp     r0, #0
    bne     1f

    mov     r0, #1
    lsl     r0, r0, #31
    orr     r0, r0, #(1 * 2)

    cmp     r1, r0
    bne     2f
    cmp     r2, #(2 * 2)
    bne     2f
    cmp     r3, #(3 * 2)
    bne     2f
    cmp     r4, #(4 * 2)
    bne     2f
    cmp     r5, #(5 * 2)
    bne     2f
    cmp     r6, #(6 * 2)
    bne     2f
    cmp     r7, #(7 * 2)
    bne     2f

    mov     r0, r8
    svc     #NN_SVC_ID_SEND_SYNC_REQUEST_LIGHT

    cmp     r0, #0
    bne     3f

    mov     r0, #1
    lsl     r0, r0, #31
    orr     r0, r0, #(1 * 4)

    cmp     r1, r0
    bne     4f
    cmp     r2, #(2 * 4)
    bne     4f
    cmp     r3, #(3 * 4)
    bne     4f
    cmp     r4, #(4 * 4)
    bne     4f
    cmp     r5, #(5 * 4)
    bne     4f
    cmp     r6, #(6 * 4)
    bne     4f
    cmp     r7, #(7 * 4)
    bne     4f

    mov     r0, #0

    pop     {r4-r8, pc}
1:  mov     r0, #2
    svc     #NN_SVC_ID_BREAK
2:  mov     r0, #2
    svc     #NN_SVC_ID_BREAK
3:  mov     r0, #2
    svc     #NN_SVC_ID_BREAK
4:  mov     r0, #2
    svc     #NN_SVC_ID_BREAK
    .size   _Z18ClientLightSessionN2nn3svc6HandleE, [. - _Z18ClientLightSessionN2nn3svc6HandleE]


    .section .text, "ax"
    .align   2
    .global  _Z18ServerLightSessionN2nn3svc6HandleE
    .type    _Z18ServerLightSessionN2nn3svc6HandleE, %function
_Z18ServerLightSessionN2nn3svc6HandleE:
    push    {r4-r8, lr}
    mov     r8, r0

    mov     r1, #0
    mov     r2, #0
    mov     r3, #0
    mov     r4, #0
    mov     r5, #0
    mov     r6, #0
    mov     r7, #0

    mov     r0, r8
    svc     #NN_SVC_ID_REPLY_AND_RECEIVE_LIGHT
    cmp     r0, #0
    bne     1f
    cmp     r1, #(1 * 1)
    bne     2f
    cmp     r2, #(2 * 1)
    bne     2f
    cmp     r3, #(3 * 1)
    bne     2f
    cmp     r4, #(4 * 1)
    bne     2f
    cmp     r5, #(5 * 1)
    bne     2f
    cmp     r6, #(6 * 1)
    bne     2f
    cmp     r7, #(7 * 1)
    bne     2f

    lsl     r1, r1, #1
    lsl     r2, r2, #1
    lsl     r3, r3, #1
    lsl     r4, r4, #1
    lsl     r5, r5, #1
    lsl     r6, r6, #1
    lsl     r7, r7, #1

    mov     r0, #1
    lsl     r0, r0, #31
    orr     r1, r0

    mov     r0, r8
    svc     #NN_SVC_ID_REPLY_AND_RECEIVE_LIGHT
    cmp     r0, #0
    bne     3f
    mov     r0, #1
    lsl     r0, r0, #31
    orr     r0, r0, #(1 * 2)
    cmp     r1, r0
    bne     4f
    cmp     r2, #(2 * 2)
    bne     4f
    cmp     r3, #(3 * 2)
    bne     4f
    cmp     r4, #(4 * 2)
    bne     4f
    cmp     r5, #(5 * 2)
    bne     4f
    cmp     r6, #(6 * 2)
    bne     4f
    cmp     r7, #(7 * 2)
    bne     4f

    lsl     r1, r1, #1
    lsl     r2, r2, #1
    lsl     r3, r3, #1
    lsl     r4, r4, #1
    lsl     r5, r5, #1
    lsl     r6, r6, #1
    lsl     r7, r7, #1

    mov     r0, #1
    lsl     r0, r0, #31
    orr     r1, r0

    mov     r0, r8
    svc     #NN_SVC_ID_REPLY_AND_RECEIVE_LIGHT
    cmp     r0, #0
    beq     5f
    pop     {r4-r8, pc}
1:  mov     r0, #2
    svc     #NN_SVC_ID_BREAK
2:  mov     r0, #2
    svc     #NN_SVC_ID_BREAK
3:  mov     r0, #2
    svc     #NN_SVC_ID_BREAK
4:  mov     r0, #2
    svc     #NN_SVC_ID_BREAK
5:  mov     r0, #2
    svc     #NN_SVC_ID_BREAK
    .size   _Z18ServerLightSessionN2nn3svc6HandleE, [. - _Z18ServerLightSessionN2nn3svc6HandleE]
#endif

#if defined NN_BUILD_CONFIG_CPU_ARM64
    .section .text, "ax"
    .align   2
    .global  _Z22ClientSendLightRequestN2nn3svc6HandleE
    .type    _Z22ClientSendLightRequestN2nn3svc6HandleE, %function
_Z22ClientSendLightRequestN2nn3svc6HandleE:
    sub     sp, sp, #8*2
    str     x20, [sp]
    mov     x20, x0

    ldr     w1, =0x80000001
    ldr     w2, =0x80000002
    ldr     w3, =0x80000003
    ldr     w4, =0x80000004
    ldr     w5, =0x80000005
    ldr     w6, =0x80000006
    ldr     w7, =0x80000007

    mov     x0, x20
    svc     #NN_SVC_ID_SEND_SYNC_REQUEST_LIGHT

    cmp     w0, #0
    b.ne    1f
    ldr     w0, =0x80000002
    cmp     w1, w0
    b.ne    2f
    cmp     w2, #(2 * 2)
    b.ne    2f
    cmp     w3, #(3 * 2)
    b.ne    2f
    cmp     w4, #(4 * 2)
    b.ne    2f
    cmp     w5, #(5 * 2)
    b.ne    2f
    cmp     w6, #(6 * 2)
    b.ne    2f
    cmp     w7, #(7 * 2)
    b.ne    2f

    mov     x0, #0

1:  ldr     x20, [sp]
    add     sp, sp, #8*2
    ret

2:  mov     x0, #2
    svc     #NN_SVC_ID_BREAK
    .size _Z22ClientSendLightRequestN2nn3svc6HandleE, [. - _Z22ClientSendLightRequestN2nn3svc6HandleE]

    .section .text, "ax"
    .align   2
    .global  _Z25ServerReceiveLightRequestN2nn3svc6HandleE
    .type    _Z25ServerReceiveLightRequestN2nn3svc6HandleE, %function
_Z25ServerReceiveLightRequestN2nn3svc6HandleE:
    sub     sp, sp, #8*2
    str     x20, [sp]
    mov     x20, x0

    mov     w1, #0
    mov     w2, #0
    mov     w3, #0
    mov     w4, #0
    mov     w5, #0
    mov     w6, #0
    mov     w7, #0

    mov     x0, x20
    svc     #NN_SVC_ID_REPLY_AND_RECEIVE_LIGHT
    cmp     x0, #0
    b.ne    1f
    ldr     w8, =0x80000001
    cmp     w1, w8
    b.ne    2f
    ldr     w8, =0x80000002
    cmp     w2, w8
    b.ne    2f
    ldr     w8, =0x80000003
    cmp     w3, w8
    b.ne    2f
    ldr     w8, =0x80000004
    cmp     w4, w8
    b.ne    2f
    ldr     w8, =0x80000005
    cmp     w5, w8
    b.ne    2f
    ldr     w8, =0x80000006
    cmp     w6, w8
    b.ne    2f
    ldr     w8, =0x80000007
    cmp     w7, w8
    b.ne    2f

1:  ldr     x20, [sp]
    add     sp, sp, #8*2
    ret

2:  mov     x0, #2
    svc     #NN_SVC_ID_BREAK
    .size _Z25ServerReceiveLightRequestN2nn3svc6HandleE, [. - _Z25ServerReceiveLightRequestN2nn3svc6HandleE]

    .section .text, "ax"
    .align   2
    .global  _Z23ServerReplyLightRequestN2nn3svc6HandleE
    .type    _Z23ServerReplyLightRequestN2nn3svc6HandleE, %function
_Z23ServerReplyLightRequestN2nn3svc6HandleE:
    sub     sp, sp, #8*2
    str     x20, [sp]
    mov     x20, x0

    ldr     w1, =0x80000002
    mov     w2, #(2 * 2)
    mov     w3, #(3 * 2)
    mov     w4, #(4 * 2)
    mov     w5, #(5 * 2)
    mov     w6, #(6 * 2)
    mov     w7, #(7 * 2)

    mov     x0, x20
    svc     #NN_SVC_ID_REPLY_AND_RECEIVE_LIGHT

    ldr     x20, [sp]
    add     sp, sp, #8*2
    ret
    .size _Z23ServerReplyLightRequestN2nn3svc6HandleE, [. - _Z23ServerReplyLightRequestN2nn3svc6HandleE]

#else
    .section .text, "ax"
    .align   2
    .global  _Z22ClientSendLightRequestN2nn3svc6HandleE
    .type    _Z22ClientSendLightRequestN2nn3svc6HandleE, %function
_Z22ClientSendLightRequestN2nn3svc6HandleE:
    push    {r4-r8, lr}
    mov     r8, r0

    mov     r1, #1
    mov     r2, #2
    mov     r3, #3
    mov     r4, #4
    mov     r5, #5
    mov     r6, #6
    mov     r7, #7

    mov     r0, r8
    svc     #NN_SVC_ID_SEND_SYNC_REQUEST_LIGHT

    cmp     r0, #0
    bne     1f

    mov     r0, #1
    lsl     r0, r0, #31
    orr     r0, r0, #(1 * 2)

    cmp     r1, r0
    bne     2f
    cmp     r2, #(2 * 2)
    bne     2f
    cmp     r3, #(3 * 2)
    bne     2f
    cmp     r4, #(4 * 2)
    bne     2f
    cmp     r5, #(5 * 2)
    bne     2f
    cmp     r6, #(6 * 2)
    bne     2f
    cmp     r7, #(7 * 2)
    bne     2f

    mov     r0, #0

1:  pop     {r4-r8, pc}
2:  mov     r0, #2
    svc     #NN_SVC_ID_BREAK
    .size   _Z22ClientSendLightRequestN2nn3svc6HandleE, [. - _Z22ClientSendLightRequestN2nn3svc6HandleE]

    .section .text, "ax"
    .align   2
    .global  _Z25ServerReceiveLightRequestN2nn3svc6HandleE
    .type    _Z25ServerReceiveLightRequestN2nn3svc6HandleE, %function
_Z25ServerReceiveLightRequestN2nn3svc6HandleE:
    push    {r4-r8, lr}
    mov     r8, r0

    mov     r1, #0
    mov     r2, #0
    mov     r3, #0
    mov     r4, #0
    mov     r5, #0
    mov     r6, #0
    mov     r7, #0

    mov     r0, r8
    svc     #NN_SVC_ID_REPLY_AND_RECEIVE_LIGHT
    cmp     r0, #0
    bne     1f

    cmp     r1, #(1 * 1)
    bne     2f
    cmp     r2, #(2 * 1)
    bne     2f
    cmp     r3, #(3 * 1)
    bne     2f
    cmp     r4, #(4 * 1)
    bne     2f
    cmp     r5, #(5 * 1)
    bne     2f
    cmp     r6, #(6 * 1)
    bne     2f
    cmp     r7, #(7 * 1)
    bne     2f

1:  pop     {r4-r8, pc}
2:  mov     r0, #2
    svc     #NN_SVC_ID_BREAK
    .size   _Z25ServerReceiveLightRequestN2nn3svc6HandleE, [. - _Z25ServerReceiveLightRequestN2nn3svc6HandleE]

    .section .text, "ax"
    .align   2
    .global  _Z23ServerReplyLightRequestN2nn3svc6HandleE
    .type    _Z23ServerReplyLightRequestN2nn3svc6HandleE, %function
_Z23ServerReplyLightRequestN2nn3svc6HandleE:
    push    {r4-r8, lr}
    mov     r8, r0

    mov     r1, #(1 * 2)
    mov     r2, #(2 * 2)
    mov     r3, #(3 * 2)
    mov     r4, #(4 * 2)
    mov     r5, #(5 * 2)
    mov     r6, #(6 * 2)
    mov     r7, #(7 * 2)

    mov     r0, #1
    lsl     r0, r0, #31
    orr     r1, r0

    mov     r0, r8
    svc     #NN_SVC_ID_REPLY_AND_RECEIVE_LIGHT
    pop     {r4-r8, pc}
    .size   _Z23ServerReplyLightRequestN2nn3svc6HandleE, [. - _Z23ServerReplyLightRequestN2nn3svc6HandleE]
#endif

