﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Result.h>
#include <nn/svc/svc_Thread.h>
#include <nn/svc/svc_HardwareParamsSelect.h>

namespace {
char g_Buffer[DefaultStackSize] __attribute__((aligned(0x1000)));
volatile int32_t g_StartFlag;
int64_t DefaultSleepTime = 100 * 1000 * 1000;

void TestThread0(uintptr_t arg)
{
    NN_UNUSED(arg);
    AutoThreadExit autoExit;
    while(g_StartFlag == 0)
    {
        nn::svc::SleepThread(DefaultSleepTime);
    }
    g_StartFlag = 2;
    while(g_StartFlag != 0)
    {
        nn::svc::SleepThread(DefaultSleepTime);
    }
}
} // namespace

/* TEST 10-1, 10-8, 10-9, 10-10, 10-11, 10-12 */
/* GetThreadPriority を用いてCreateThread で与えたpriority と同じ優先度が取得できるかを確認します */
TEST(GetThreadPriorityTest, NormalCaseTest)
{
    TestThreadLeak leakTest;
    nn::svc::Handle handle;
    nn::Result result;
    int32_t priority;
    int32_t idealCore;
    int32_t tmpPriority;
    uintptr_t sp;
    uintptr_t pc;

    sp = reinterpret_cast<uintptr_t>(g_Buffer + sizeof(g_Buffer));
    pc = reinterpret_cast<uintptr_t>(TestThread0);

    for (idealCore = 0; idealCore < NumCore; idealCore++)
    {
        for (priority = TestHighestThreadPriority;
                priority <= TestLowestThreadPriority; priority++)
        {
            g_StartFlag = 0;
            result = nn::svc::CreateThread(&handle, pc, 0, sp, priority, idealCore);
            ASSERT_RESULT_SUCCESS(result);

            // TEST 10-1 (同じコア) or TEST 10-10 (違うコア)
            result = nn::svc::GetThreadPriority(&tmpPriority, handle);
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::StartThread(handle);
            ASSERT_RESULT_SUCCESS(result);

            g_StartFlag = 1;
            while(g_StartFlag == 1)
            {
                nn::svc::SleepThread(DefaultSleepTime);
            }

            // TEST 10-8 (同じコア) or TEST 10-11 (違うコア)
            result = nn::svc::GetThreadPriority(&tmpPriority, handle);
            ASSERT_RESULT_SUCCESS(result);

            g_StartFlag = 0;
            int32_t index;
            result = nn::svc::WaitSynchronization(&index, &handle, 1, -1);
            ASSERT_RESULT_SUCCESS(result);

            // TEST 10-9 (同じコア) or TEST 10-12 (違うコア)
            result = nn::svc::GetThreadPriority(&tmpPriority, handle);
            ASSERT_RESULT_SUCCESS(result);

            result = nn::svc::CloseHandle(handle);
            ASSERT_RESULT_SUCCESS(result);
        }
    }
}

