﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include <nn/svc/svc_Thread.h>
#include <nn/nn_Common.h>

namespace {
char g_Buffer[DefaultStackSize] __attribute__((aligned(0x1000)));

void ThreadIdTest(uintptr_t arg)
{
    NN_UNUSED(arg);
    AutoThreadExit autoExit;
}

} // namespace

extern "C" void nnMain();

#ifdef INVALID_POINTER_TEST
TEST(GetThreadId, InvalidPointer)
{
    TestThreadLeak leakTest;
    nn::Result result;
    uintptr_t addr;

#ifdef INVALID_POINTER_TEST
    // TEST 32-12
    // NULL を渡すと失敗する
    result = nn::svc::GetThreadId(NULL, nn::svc::PSEUDO_HANDLE_CURRENT_THREAD);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
#endif // INVALID_POINTER_TEST

#ifdef INVALID_POINTER_TEST
    // TEST 32-13
    // MemoryPermission_None を渡すと失敗する
    result = nn::svc::GetThreadId
        (reinterpret_cast<nn::Bit64*>(g_FreeAreaBegin), nn::svc::PSEUDO_HANDLE_CURRENT_THREAD);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
#endif // INVALID_POINTER_TEST

#ifdef INVALID_POINTER_TEST
    // TEST 32-14
    // MemoryPermission_Read を渡すと失敗する
    {
        size_t memSize = 0x1000;
        result = nn::svc::SetHeapSize(&addr, HeapAlign);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::SetMemoryPermission(addr, memSize, nn::svc::MemoryPermission_Read);
        ASSERT_RESULT_SUCCESS(result);
        result = nn::svc::GetThreadId
            (reinterpret_cast<nn::Bit64*>(addr), nn::svc::PSEUDO_HANDLE_CURRENT_THREAD);
        ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
        result = nn::svc::SetMemoryPermission(addr, memSize, nn::svc::MemoryPermission_ReadWrite);
        ASSERT_RESULT_SUCCESS(result);

        result = nn::svc::SetHeapSize(&addr, 0);
        ASSERT_RESULT_SUCCESS(result);
    }
#endif // INVALID_POINTER_TEST

#ifdef INVALID_POINTER_TEST
    // TEST 32-15
    // プロセスのコード領域を渡すと失敗する
    addr = reinterpret_cast<uintptr_t>(nnMain);
    result = nn::svc::GetThreadId
        (reinterpret_cast<nn::Bit64*>(addr), nn::svc::PSEUDO_HANDLE_CURRENT_THREAD);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPointer());
#endif // INVALID_POINTER_TEST
}
#endif // INVALID_POINTER_TEST

TEST(GetThreadId, InvalidHandle)
{
    TestThreadLeak leakTest;
    nn::Result result;
    nn::Bit64 threadId;
    nn::svc::Handle threadHandle;
    uintptr_t sp;
    uintptr_t pc;

    // TEST 32-18
    // INVALID_HANDLE_VALUE を渡すと失敗する
    result = nn::svc::GetThreadId(&threadId, nn::svc::INVALID_HANDLE_VALUE);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());


    // TEST 32-19
    // Close したスレッドのハンドルを渡すと失敗する
    pc = reinterpret_cast<uintptr_t>(ThreadIdTest);
    sp = reinterpret_cast<uintptr_t>(g_Buffer + sizeof(g_Buffer));
    result = nn::svc::CreateThread(&threadHandle, pc, 0, sp, 32, 0);
    ASSERT_RESULT_SUCCESS(result);
    result = nn::svc::CloseHandle(threadHandle);
    ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::GetThreadId(&threadId, threadHandle);
    ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidHandle());
}

