﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/init.h>
#include "test_Common.h"

#if defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK1 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK2 )
#include "test_TestTmrDevice_Jetson.h"
#endif

namespace {
}

extern "C" void nndiagStartup()
{
}

extern "C" void nninitStartup()
{
}

extern "C" void nnMain()
{
    nn::Result result;

    // 許可されているスレッドの優先度の範囲外に設定できない
    result = nn::svc::SetThreadPriority(
            nn::svc::PSEUDO_HANDLE_CURRENT_THREAD, TestLowestThreadPriority);
    NN_ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::SetThreadPriority(
            nn::svc::PSEUDO_HANDLE_CURRENT_THREAD, TestLowestThreadPriority + 1);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPriority());

    result = nn::svc::SetThreadPriority(
            nn::svc::PSEUDO_HANDLE_CURRENT_THREAD, TestHighestThreadPriority);
    NN_ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::SetThreadPriority(
            nn::svc::PSEUDO_HANDLE_CURRENT_THREAD, TestHighestThreadPriority - 1);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidPriority());

    // 許可されているコアの範囲外に設定できない
    nn::Bit64 mask;
    int32_t idealCore;

    idealCore = 0;
    mask = 1 << idealCore;
    result = nn::svc::SetThreadCoreMask(
            nn::svc::PSEUDO_HANDLE_CURRENT_THREAD, idealCore, mask);
    NN_ASSERT_RESULT_SUCCESS(result);

    idealCore = 1;
    mask = 1 << idealCore;
    result = nn::svc::SetThreadCoreMask(
            nn::svc::PSEUDO_HANDLE_CURRENT_THREAD, idealCore, mask);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultInvalidCoreNumber());

    // 許可されている割り込み以外を設定できない
#if defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK1 ) \
    || defined( NN_BUILD_CONFIG_HARDWARE_JETSONTK2 )
    nn::svc::Handle readableEvent;
    int32_t name = TmrDefaultInterruptNumber;
    nn::svc::InterruptType type = nn::svc::InterruptType_Level;

    result = nn::svc::CreateInterruptEvent(&readableEvent, name, type);
    NN_ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::CloseHandle(readableEvent);
    NN_ASSERT_RESULT_SUCCESS(result);

    name = static_cast<nn::svc::Interrupt>(TmrDefaultInterruptNumber + 1);
    result = nn::svc::CreateInterruptEvent(&readableEvent, name, type);
    NN_ASSERT_RESULT_FAILURE_VALUE(result, nn::svc::ResultNotFound());
#endif

#ifdef ENABLE_MAX_HANDLE_TEST
    // 許可されているハンドルの数以上のハンドルを生成できない
    {
        ConsumeHandle maxHandle;
        NN_ASSERT_EQUAL(NumMaxHandle - 1, maxHandle.GetCount());
    }
#endif // ENABLE_MAX_HANDLE_TEST
}
