﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "test_Common.h"
#include "test_AliasCode.h"
#include "util_TestIpc.h"
#include <nn/svc/ipc/svc_SessionMessage.h>

extern "C" void nndiagStartup()
{
}

extern "C" void nninitStartup()
{
}

uintptr_t g_HeapAreaBegin;
uintptr_t g_HeapAreaEnd;
uintptr_t g_ReservedAreaBegin;
uintptr_t g_ReservedAreaEnd;
uintptr_t g_FreeAreaBegin;
uintptr_t g_FreeAreaEnd;

extern"C" void nnMain()
{
    InitTestMemory();

    nn::Result result;

    nn::svc::Handle clientSession;

    result = nn::svc::ConnectToNamedPort(&clientSession, AliasCodePortName);
    NN_ASSERT_RESULT_SUCCESS(result);

    nn::svc::Handle writableEvent1;
    nn::svc::Handle readableEvent1;
    result = nn::svc::CreateEvent(&writableEvent1, &readableEvent1);
    NN_ASSERT_RESULT_SUCCESS(result);

    nn::svc::Handle writableEvent2;
    nn::svc::Handle readableEvent2;
    result = nn::svc::CreateEvent(&writableEvent2, &readableEvent2);
    NN_ASSERT_RESULT_SUCCESS(result);

    SendMoveHandle(readableEvent1, clientSession);
    SendMoveHandle(writableEvent2, clientSession);

    nn::svc::Handle process;
    ReceiveServerProcessHandle(&process, clientSession);

    uint64_t normal;
    ClientReceiveData(&normal, sizeof(normal), clientSession);

    uint64_t freeArea;
    ClientReceiveData(&freeArea, sizeof(freeArea), clientSession);

    uint64_t size;
    ClientReceiveData(&size, sizeof(size), clientSession);

    nn::svc::MemoryPermission perm;
    ClientReceiveData(&perm, sizeof(perm), clientSession);

    result = nn::svc::MapProcessCodeMemory(process, freeArea, normal, size);
    NN_ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::SetProcessMemoryPermission(
            process, freeArea, size, perm);
    NN_ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::SignalEvent(writableEvent1);
    NN_ASSERT_RESULT_SUCCESS(result);

    int32_t index;
    result = nn::svc::WaitSynchronization(&index, &readableEvent2, 1, -1);
    NN_ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::UnmapProcessCodeMemory(process, freeArea, normal, size);
    NN_ASSERT_RESULT_SUCCESS(result);

    result = nn::svc::CloseHandle(writableEvent1);
    NN_ASSERT_RESULT_SUCCESS(result);
    result = nn::svc::CloseHandle(readableEvent2);
    NN_ASSERT_RESULT_SUCCESS(result);
    result = nn::svc::CloseHandle(clientSession);
    NN_ASSERT_RESULT_SUCCESS(result);
}

