﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "sdmmc_GcAsic.h"
#include <nn/TargetConfigs/build_Base.h>
#include "detail/sdmmc_GcAsicDeviceAccessor.h"
#if (defined(NN_DETAIL_SDMMC_PORT_GC_ASIC_0_ENABLE) && (!defined(NN_DETAIL_SDMMC_ATTACH_MMC_TO_PORT_GC_ASIC_0_FOR_DEBUG)))
    #include "detail/sdmmc_PortGcAsic0.h"
#endif
#include <nn/nn_Abort.h>

namespace nn { namespace sdmmc1 {

namespace
{
    detail::GcAsicDeviceAccessor* GetGcAsicDeviceAccessor(Port port) NN_NOEXCEPT
    {
        detail::GcAsicDeviceAccessor* pGcAsicDeviceAccessor = nullptr;
        switch (port)
        {
        #if (defined(NN_DETAIL_SDMMC_PORT_GC_ASIC_0_ENABLE) && (!defined(NN_DETAIL_SDMMC_ATTACH_MMC_TO_PORT_GC_ASIC_0_FOR_DEBUG)))
            case Port_GcAsic0:
                pGcAsicDeviceAccessor = detail::GetGcAsicDeviceAccessorOfPortGcAsic0();
                break;
        #endif
        default:
            NN_UNEXPECTED_DEFAULT;
        }
        NN_ABORT_UNLESS_NOT_NULL(pGcAsicDeviceAccessor);
        return pGcAsicDeviceAccessor;
    }
}

Result ActivateGcAsic(Port port) NN_NOEXCEPT
{
    detail::GcAsicDeviceAccessor* pGcAsicDeviceAccessor = GetGcAsicDeviceAccessor(port);
    return pGcAsicDeviceAccessor->ActivateGcAsic();
}

Result GetGcAsicSpeedMode(SpeedMode* pOutSpeedMode, Port port) NN_NOEXCEPT
{
    detail::GcAsicDeviceAccessor* pGcAsicDeviceAccessor = GetGcAsicDeviceAccessor(port);
    return pGcAsicDeviceAccessor->GetGcAsicSpeedMode(pOutSpeedMode);
}

Result WriteGcAsicOperation(Port port, const void* pOperationBuffer, size_t operationBufferSize) NN_NOEXCEPT
{
    detail::GcAsicDeviceAccessor* pGcAsicDeviceAccessor = GetGcAsicDeviceAccessor(port);
    return pGcAsicDeviceAccessor->WriteGcAsicOperation(pOperationBuffer, operationBufferSize);
}

Result FinishGcAsicOperation(Port port) NN_NOEXCEPT
{
    detail::GcAsicDeviceAccessor* pGcAsicDeviceAccessor = GetGcAsicDeviceAccessor(port);
    return pGcAsicDeviceAccessor->FinishGcAsicOperation();
}

Result SleepGcAsic(Port port) NN_NOEXCEPT
{
    detail::GcAsicDeviceAccessor* pGcAsicDeviceAccessor = GetGcAsicDeviceAccessor(port);
    return pGcAsicDeviceAccessor->SleepGcAsic();
}

Result UpdateGcAsicKey(Port port) NN_NOEXCEPT
{
    detail::GcAsicDeviceAccessor* pGcAsicDeviceAccessor = GetGcAsicDeviceAccessor(port);
    return pGcAsicDeviceAccessor->UpdateGcAsicKey();
}

void SignalGcRemovedEvent(Port port) NN_NOEXCEPT
{
    detail::GcAsicDeviceAccessor* pGcAsicDeviceAccessor = GetGcAsicDeviceAccessor(port);
    pGcAsicDeviceAccessor->SignalGcRemovedEvent();
}

void ClearGcRemovedEvent(Port port) NN_NOEXCEPT
{
    detail::GcAsicDeviceAccessor* pGcAsicDeviceAccessor = GetGcAsicDeviceAccessor(port);
    pGcAsicDeviceAccessor->ClearGcRemovedEvent();
}

}} // namespace nn { namespace sdmmc1 {
