﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../../include/nn/i2c/driver/i2c.h"
#include <nn/os/os_Mutex.h>

#include "i2c_BusAccessor.h"
#include "i2c_Session.h"

namespace nn {
namespace i2c {
namespace driver {
namespace detail {

class ResourceManager
{
    NN_DISALLOW_COPY(ResourceManager);
    NN_DISALLOW_MOVE(ResourceManager);

private:
    ResourceManager() NN_NOEXCEPT :
        m_InitializeCount(0),
        m_InitializeCountMutex(false),
        m_SessionIsOpenMutex(false)
        {}

public:
    static ResourceManager& GetInstance() NN_NOEXCEPT
    {
        static ResourceManager instance;
        return instance;
    }

    Session& GetSession( int sessionId ) NN_NOEXCEPT
    {
        return m_Sessions[sessionId];
    }

    bool     IsInitialized() const NN_NOEXCEPT
    {
        return (m_InitializeCount > 0);
    }

    void     Initialize() NN_NOEXCEPT;
    void     Finalize() NN_NOEXCEPT;

    void     OpenSession(I2cSession* pOutSession, int busIdx, Bit16 slaveAddress, AddressingMode addressingMode, SpeedMode speedMode ) NN_NOEXCEPT;
    void     CloseSession( const I2cSession& session ) NN_NOEXCEPT;

private:
    int      FindFreeSessionId() const NN_NOEXCEPT;

private:
    int           m_InitializeCount;
    Session       m_Sessions[MaxSessions];
    BusAccessor   m_BusAccessor[MaxBuses];
    nn::os::Mutex m_InitializeCountMutex;  // ロック対象は m_InitializeCount
    nn::os::Mutex m_SessionIsOpenMutex;    // ロック対象は Session::IsOpen
};

} // detail
} // driver
} // i2c
} // nn
