﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt.h>
#include <nn/os.h>
#include <nn/nn_Log.h>


static const int MAX_NUM_CORES = 4;
static const size_t STACK_SIZE = 4096;
// save thread info into file
static const char* mountName = "save";
static const char* saveFilePath = "save:/test_cpu_thread.txt";


// args to pass into the busy thread function
struct ThreadArg {
    int cpu_core = 3;
    int busy_wait_ms = 10;
    int thread_priority = 19;
    int thread_duty_cycle_percent = 30;
};


class CpuUseTestFixture : public ::testing::Test
{
protected:
    nn::os::ThreadType threadForUse;
    ThreadArg threadArgs;

    // setup and teardown for each test case
    virtual void SetUp();
    virtual void TearDown();

public:
    // file to signal if the thread should terminate
    bool static IsSignalFileExists();
    bool static CreateSignalFile();
    bool static DeleteSignalFile();
};
