﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>

#include <nnt.h>
#include <nn/nn_Log.h>

#include <nn/spy.h>

#include <nn/spy/detail/fnd/basis/spyfnd_Time.h>
#include <nn/spy/detail/fnd/string/spyfnd_String.h>

TEST(TimeSpan, Basic)
{
    nn::spy::detail::fnd::TimeSpan nano = nn::spy::detail::fnd::TimeSpan::FromNanoSeconds(1);
    EXPECT_EQ(1, nano.ToNanoSeconds());

    nn::spy::detail::fnd::TimeSpan micro = nn::spy::detail::fnd::TimeSpan::FromMicroSeconds(1);
    EXPECT_EQ(1, micro.ToMicroSeconds());
    EXPECT_EQ(1000, micro.ToNanoSeconds());

    nn::spy::detail::fnd::TimeSpan milli = nn::spy::detail::fnd::TimeSpan::FromMilliSeconds(1);
    EXPECT_EQ(1, milli.ToMilliSeconds());
    EXPECT_EQ(1000, milli.ToMicroSeconds());

    nn::spy::detail::fnd::TimeSpan current = nn::spy::detail::fnd::Time::Current();
    EXPECT_NE(0, current.ToNanoSeconds());
}

TEST(String, Copy)
{
    char buff[8];

    nn::spy::detail::fnd::String::Copy(buff, 8, "");
    EXPECT_TRUE(std::strcmp(buff, "") == 0);

    nn::spy::detail::fnd::String::Copy(buff, 8, "a");
    EXPECT_TRUE(std::strcmp(buff, "a") == 0);

    nn::spy::detail::fnd::String::Copy(buff, 8, "abcdefg");
    EXPECT_TRUE(std::strcmp(buff, "abcdefg") == 0);

    nn::spy::detail::fnd::String::Copy(buff, 8, "abcdefgh");
    EXPECT_TRUE(std::strcmp(buff, "abcdefg") == 0);

    nn::spy::detail::fnd::String::Copy(buff, "");
    EXPECT_TRUE(std::strcmp(buff, "") == 0);

    nn::spy::detail::fnd::String::Copy(buff, "a");
    EXPECT_TRUE(std::strcmp(buff, "a") == 0);

    nn::spy::detail::fnd::String::Copy(buff, "abcdefg");
    EXPECT_TRUE(std::strcmp(buff, "abcdefg") == 0);

    nn::spy::detail::fnd::String::Copy(buff, "abcdefgh");
    EXPECT_TRUE(std::strcmp(buff, "abcdefg") == 0);
}
