﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Microsoft.VisualStudio.TestTools.UnitTesting;
using Microsoft.VSSDK.Tools.VsIdeTesting;
using Nintendo.NintendoSdkVsExtension.VcAccessors;
using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Xml.Linq;

namespace Nintendo.NintendoSdkVsExtension.UnitTest.VcAccessorsTest
{
    [TestClass]
    [DeploymentItem(InIdeTestConstants.VsVersionSpecificTestDataSourceDirectory + @"Project.Generic", @"Data\Project.Generic")]
    public class AddPropertySheetTest
    {
        public TestContext TestContext { get; set; }

        [TestInitialize]
        public void TestInitialize()
        {
            VsTestUtil.EnsureOpenSolution(@"Data\Project.Generic\Project.sln");
        }

        [TestCleanup]
        public void ClassCleanup()
        {
            // 本クラスのテストはプロジェクトを編集するので、閉じて開き直す
            VsTestUtil.ForceCloseSolution();
        }

        private static VcProjectAccessor GetTargetProject()
        {
            return VsTestUtil.GetVcProjectOfName(@"Project\Project.vcxproj");
        }

        [TestMethod]
        [HostType("VS IDE")]
        public void TestAddPropertySheet()
        {
            VcProjectAccessor project = GetTargetProject();

            var configurations = project.Configurations;
            foreach (var c in configurations)
            {
                var props = c.AddPropertySheet("NewProps.props");
                Assert.AreEqual("NewProps", props.Name);
                CollectionAssert.Contains(c.PropertySheets.ToArray(), props);
                c.RemovePropertySheet(props);
                CollectionAssert.DoesNotContain(c.PropertySheets.ToArray(), props);
            }
        }
    }
}
