﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>
#include "TestAppSimple_SceneCommon.h"

class HtmlDocScene : public SceneCommon
{
    NN_DISALLOW_COPY(HtmlDocScene);

public:
    HtmlDocScene() NN_NOEXCEPT;
    virtual ~HtmlDocScene() NN_NOEXCEPT NN_OVERRIDE {}

protected:
    virtual void InternalSetup() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleNPad() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalHandleTouchScreen() NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalDrawDebugText(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT NN_OVERRIDE;
    virtual void InternalProcess() NN_NOEXCEPT NN_OVERRIDE;

private:
    void ReadHtmlPath() NN_NOEXCEPT;
    void ResetPathRangeList() NN_NOEXCEPT;
    void DrawPathList(nn::gfx::util::DebugFontTextWriter* writer) NN_NOEXCEPT;

private:
    enum State
    {
        State_None,
        State_LaunchReady,
        State_Launching,
        State_LaunchFailed,
    };

    State m_State;

    // meta情報表示の最大行数定義
    static const int MaxItemCount = 8;

    bool m_IsExistHtmlDocFile;
    std::string m_LaunchHtmlPagePath;
    std::vector<std::string> m_HtmlFilePathList;
    uint32_t m_LastResultValue;

    int m_CurrentSelectPos;
    int m_CurrentMaxPosNum;
    int m_CurrentPage;
    int m_LastPage;

    SceneCommon::TouchRange m_LaunchBrowserRange;
    SceneCommon::TouchRange m_FailedOkRange;

    SceneCommon::TouchRange m_PathRangeList[MaxItemCount];

    SceneCommon::TouchRange m_NextPageRange;
    SceneCommon::TouchRange m_BackPageRange;

    WarningView m_WarningView;
    // メッセージ中で変動する箇所の配列インデックス
    size_t m_PathMsgIdx;
};
