﻿using Nintendo.Foundation.IO;

namespace MakeMiniDump
{
    class CommandLineOption
    {
        [CommandLineOption("name", Description = "The process name of the process for creating the minidump.")]
        public string Name { get; set; }

        [CommandLineOption("pid", Description = "The process ID of the process for creating the minidump.")]
        public string Pid { get; set; }

        [CommandLineOption("out", Description = "The output path of the minidump.", IsRequired = true)]
        public string Out { get; set; }

        [CommandLineOption("force", Description = "Force over written the out put path.", IsRequired = false, DefaultValue = false)]
        public bool Force { get; set; }
    }
}
