﻿using System;
using System.Diagnostics;
using System.IO;
using System.Text;

namespace DecodeStackTrace
{
    internal static class ProcessInvoker
    {
        internal static string Invoke(string fileName, string arguments)
        {
            using (var p = new Process())
            {
                p.StartInfo = new ProcessStartInfo()
                {
                    FileName = fileName,
                    Arguments = arguments,
                    UseShellExecute = false,
                    CreateNoWindow = true,
                    RedirectStandardOutput = true,
                    RedirectStandardError = true,
                    StandardOutputEncoding = Encoding.UTF8,
                    StandardErrorEncoding = Encoding.UTF8,
                };

                var sb = new StringBuilder();
                var handler = new DataReceivedEventHandler((sender, e) =>
                {
                    if (e.Data != null)
                    {
                        lock (sb) sb.AppendLine(e.Data);
                    }
                });

                p.OutputDataReceived += handler;
                p.ErrorDataReceived += handler;

                p.Start();
                p.BeginOutputReadLine();
                p.BeginErrorReadLine();
                p.WaitForExit();

                var exitCode = p.ExitCode;

                if (!(exitCode == 0))
                {
                    var baseName = Path.GetFileName(fileName);
                    throw new Exception(
                        $"{baseName} failed with exit code {exitCode}.");
                }

                return sb.ToString();
            }
        }
    }
}
