﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Collections.Generic;
using System.Linq;

namespace NintendoWare.Spy.Extensions.Tests
{
    [TestClass]
    public class EnumerableExtensionTests
    {
        [TestMethod]
        public void SuccessingPair_a1()
        {
            var array = Enumerable.Empty<int>()
                .SuccessingPair()
                .ToArray();

            Assert.AreEqual(0, array.Length);
        }

        [TestMethod]
        public void SuccessingPair_a2()
        {
            var array = Enumerable.Range(100, 1)
                .SuccessingPair()
                .ToArray();

            Assert.AreEqual(0, array.Length);
        }

        [TestMethod]
        public void SuccessingPair_a3()
        {
            var array = Enumerable.Range(100, 3)
                .SuccessingPair()
                .ToArray();

            Assert.AreEqual(2, array.Length);
            Assert.AreEqual(100, array[0].Item1);
            Assert.AreEqual(101, array[0].Item2);
            Assert.AreEqual(101, array[1].Item1);
            Assert.AreEqual(102, array[1].Item2);
        }

        [TestMethod]
        [ExpectedException(typeof(ArgumentNullException))]
        public void SuccessingPair_a4()
        {
            IEnumerable<int> enumerable = null;
            enumerable
                .SuccessingPair();
        }

        [TestMethod]
        public void SuccessingPair_b1()
        {
            var array = Enumerable.Empty<int>()
                .SuccessingPair((i, j) => new { Item1 = i, Item2 = j })
                .ToArray();

            Assert.AreEqual(0, array.Length);
        }

        [TestMethod]
        public void SuccessingPair_b2()
        {
            var array = Enumerable.Range(100, 1)
                .SuccessingPair((i, j) => new { Item1 = i, Item2 = j })
                .ToArray();

            Assert.AreEqual(0, array.Length);
        }

        [TestMethod]
        public void SuccessingPair_b3()
        {
            var array = Enumerable.Range(100, 3)
                .SuccessingPair((i, j) => new { Item1 = i, Item2 = j })
                .ToArray();

            Assert.AreEqual(2, array.Length);
            Assert.AreEqual(100, array[0].Item1);
            Assert.AreEqual(101, array[0].Item2);
            Assert.AreEqual(101, array[1].Item1);
            Assert.AreEqual(102, array[1].Item2);
        }

        [TestMethod]
        [ExpectedException(typeof(ArgumentNullException))]
        public void SuccessingPair_b4()
        {
            IEnumerable<int> enumerable = null;
            enumerable
                .SuccessingPair((i, j) => i + j);
        }

        [TestMethod]
        [ExpectedException(typeof(ArgumentNullException))]
        public void SuccessingPair_b5()
        {
            Func<int, int, int> selector = null;
            Enumerable.Range(100, 3)
                .SuccessingPair(selector);
        }

        [TestMethod]
        public void SuccessingTriple_a1()
        {
            var array = Enumerable.Empty<int>()
                .SuccessingTriple()
                .ToArray();

            Assert.AreEqual(0, array.Length);
        }

        [TestMethod]
        public void SuccessingTriple_a2()
        {
            var array = Enumerable.Range(100, 1)
                .SuccessingTriple()
                .ToArray();

            Assert.AreEqual(0, array.Length);
        }

        [TestMethod]
        public void SuccessingTriple_a3()
        {
            var array = Enumerable.Range(100, 2)
                .SuccessingTriple()
                .ToArray();

            Assert.AreEqual(0, array.Length);
        }

        [TestMethod]
        public void SuccessingTriple_a4()
        {
            var array = Enumerable.Range(100, 4)
                .SuccessingTriple()
                .ToArray();

            Assert.AreEqual(2, array.Length);
            Assert.AreEqual(100, array[0].Item1);
            Assert.AreEqual(101, array[0].Item2);
            Assert.AreEqual(102, array[0].Item3);
            Assert.AreEqual(101, array[1].Item1);
            Assert.AreEqual(102, array[1].Item2);
            Assert.AreEqual(103, array[1].Item3);
        }

        [TestMethod]
        [ExpectedException(typeof(ArgumentNullException))]
        public void SuccessingTriple_a5()
        {
            IEnumerable<int> enumerable = null;
            enumerable
                .SuccessingTriple();
        }

        [TestMethod]
        public void SuccessingTriple_b1()
        {
            var array = Enumerable.Empty<int>()
                .SuccessingTriple((i, j, k) => new { Item1 = i, Item2 = j, Item3 = k })
                .ToArray();

            Assert.AreEqual(0, array.Length);
        }

        [TestMethod]
        public void SuccessingTriple_b2()
        {
            var array = Enumerable.Range(100, 1)
                .SuccessingTriple((i, j, k) => new { Item1 = i, Item2 = j, Item3 = k })
                .ToArray();

            Assert.AreEqual(0, array.Length);
        }

        [TestMethod]
        public void SuccessingTriple_b3()
        {
            var array = Enumerable.Range(100, 2)
                .SuccessingTriple((i, j, k) => new { Item1 = i, Item2 = j, Item3 = k })
                .ToArray();

            Assert.AreEqual(0, array.Length);
        }

        [TestMethod]
        public void SuccessingTriple_b4()
        {
            var array = Enumerable.Range(100, 4)
                .SuccessingTriple((i, j, k) => new { Item1 = i, Item2 = j, Item3 = k })
                .ToArray();

            Assert.AreEqual(2, array.Length);
            Assert.AreEqual(100, array[0].Item1);
            Assert.AreEqual(101, array[0].Item2);
            Assert.AreEqual(102, array[0].Item3);
            Assert.AreEqual(101, array[1].Item1);
            Assert.AreEqual(102, array[1].Item2);
            Assert.AreEqual(103, array[1].Item3);
        }

        [TestMethod]
        [ExpectedException(typeof(ArgumentNullException))]
        public void SuccessingTriple_b5()
        {
            IEnumerable<int> enumerable = null;
            enumerable
                .SuccessingTriple((i, j, k) => new { Item1 = i, Item2 = j, Item3 = k });
        }

        [TestMethod]
        [ExpectedException(typeof(ArgumentNullException))]
        public void SuccessingTriple_b6()
        {
            Func<int, int, int, int> selector = null;
            Enumerable.Range(100, 3)
                .SuccessingTriple(selector);
        }

        [TestMethod()]
        public void ListSkipTest()
        {
            var list = new[] { 0, 1, 2, 3, 4 };

            Assert.IsTrue(list.ListSkip(-1).SequenceEqual(new[] { 0, 1, 2, 3, 4 }));
            Assert.IsTrue(list.ListSkip(0).SequenceEqual(new[] { 0, 1, 2, 3, 4 }));
            Assert.IsTrue(list.ListSkip(2).SequenceEqual(new[] { 2, 3, 4 }));
            Assert.IsTrue(list.ListSkip(5).SequenceEqual(new int[0]));
            Assert.IsTrue(list.ListSkip(6).SequenceEqual(new int[0]));
        }

        [TestMethod()]
        [ExpectedException(typeof(ArgumentNullException))]
        public void ListSkipTest_e1()
        {
            IList<int> list = null;

            list.ListSkip(10);
        }

        [TestMethod()]
        [ExpectedException(typeof(InvalidOperationException))]
        public void ListSkipTest_e2()
        {
            var list2 = new List<int> { 0, 1, 2, 3, 4 };

            foreach (var i in list2)
            {
                if (i == 2)
                {
                    list2.Add(i);
                }
            }
        }
    }
}
