﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Microsoft.VisualStudio.TestTools.UnitTesting;
using NintendoWare.Spy.Foundation;
using NintendoWare.Spy.Foundation.Commands;

namespace NintendoWare.Spy.Commands.Tests
{
    [TestClass()]
    public class AudioSaveRecordWaveDataDialogCommandArgsTests
    {
        [TestMethod()]
        public void AudioSaveRecordWaveDataDialogCommandArgsTest()
        {
            var args = new AudioSaveRecordWaveDataDialogCommandArgs();

            // DeepCone() は動くか。
            AudioSaveRecordWaveDataDialogCommandArgs clone1 = args.DeepClone();

            Assert.IsNotNull(clone1);
            Assert.IsTrue(!object.ReferenceEquals(args, clone1));
            Assert.IsTrue(!object.ReferenceEquals(args.SaveFileDialogCommandArgs, clone1.SaveFileDialogCommandArgs));
            Assert.AreEqual(args.OutputFilePath, clone1.OutputFilePath);
            Assert.AreEqual(args.SaveFileDialogCommandArgs.FileName, clone1.SaveFileDialogCommandArgs.FileName);

            // args を変更しても clone1 には伝わらない。
            args.OutputFilePath = "dummy1";
            args.SaveFileDialogCommandArgs.FileName = "dummy2";

            Assert.AreNotEqual(args.OutputFilePath, clone1.OutputFilePath);
            Assert.AreNotEqual(args.SaveFileDialogCommandArgs.FileName, clone1.SaveFileDialogCommandArgs.FileName);

            // クローンし直したら変更が反映されていることを確認。
            clone1 = args.DeepClone();

            Assert.AreEqual(args.OutputFilePath, clone1.OutputFilePath);
            Assert.AreEqual(args.SaveFileDialogCommandArgs.FileName, clone1.SaveFileDialogCommandArgs.FileName);

            // 多態性は機能しているか。
            SpyPlaybackServiceCommandArgs clone2 = (args as SpyPlaybackServiceCommandArgs).DeepClone();

            Assert.IsNotNull(clone2);
            Assert.IsTrue(!object.ReferenceEquals(args, clone2));
            Assert.IsInstanceOfType(clone2, typeof(AudioSaveRecordWaveDataDialogCommandArgs));

            // CommandArgs の DeepClone() は未実装。呼ばれるはずはない。
            CommandArgs clone3 = (args as CommandArgs).DeepClone();

            Assert.IsNotNull(clone3);
            Assert.IsTrue(!object.ReferenceEquals(args, clone3));
            Assert.IsInstanceOfType(clone3, typeof(AudioSaveRecordWaveDataDialogCommandArgs));
        }
    }
}
