﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nn/nn_Log.h>
#include <nn/nn_Abort.h>
#include <string>
#include <algorithm>
#include "testRepair_Utility.h"
#include <nn/repair/repair_IFile.h>
#include <memory>
#include <nn/fs.h>
#include <nn/repair/repair_FileSystem.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/repair/repair_CryptUtility.h>
#include <nn/repair/repair_Authentication.h>
#include <nn/crypto.h>
#include <random>
#include <functional>
#include <nn/repair/repair_ProtectedFile.h>
#include <nn/manu/manu_Api.h>
#include <nn/spl/spl_Api.h>
#include <nn/crypto/crypto_RsaOaepSha256Decoder.h>
#include <nn/crypto/crypto_RsaOaepDecryptor.h>
#include <nn/crypto/crypto_RsaOaepEncryptor.h>

using namespace nnt::repair;
using namespace nn::repair;

namespace {
    uint8_t Modulus[] = {
        0xE6, 0x5C, 0x8D, 0xF5, 0xCD, 0xAA, 0xAC, 0x0B, 0x29, 0x8C, 0x9B, 0x10, 0xF6, 0xC5, 0x95, 0xD2,
        0xD6, 0x90, 0x77, 0x5D, 0xF3, 0x70, 0xF5, 0x17, 0xD4, 0xD7, 0xB1, 0xB2, 0xB0, 0x47, 0xB4, 0x49,
        0xE0, 0xCF, 0x2A, 0xB8, 0x4E, 0x22, 0xE0, 0x68, 0xED, 0xE6, 0x00, 0x77, 0x81, 0x2D, 0xB0, 0xB9,
        0xEB, 0xC3, 0x79, 0x13, 0x47, 0xD0, 0x86, 0x99, 0x99, 0xF3, 0xA0, 0x67, 0xD6, 0x6F, 0xB1, 0x80,
        0x37, 0x4A, 0xC2, 0xD6, 0xC2, 0xAF, 0xE0, 0x46, 0xB2, 0x6B, 0xFE, 0x00, 0x3C, 0x39, 0x86, 0xAB,
        0x83, 0xF6, 0xAC, 0xA9, 0x38, 0x34, 0xB8, 0xE1, 0xDE, 0xD5, 0x78, 0x08, 0x80, 0xD2, 0x58, 0xB8,
        0x04, 0x23, 0x19, 0xCF, 0x5B, 0xDC, 0x5A, 0x72, 0x04, 0x7C, 0xB9, 0x65, 0x4A, 0x59, 0x37, 0x54,
        0xB9, 0xDA, 0xE2, 0x99, 0x1F, 0x4B, 0xA3, 0x77, 0x4C, 0x62, 0x22, 0x20, 0xFB, 0x27, 0xEF, 0x73,
        0xE5, 0x90, 0x01, 0x6F, 0x52, 0x62, 0xF0, 0x2A, 0x45, 0xA7, 0xC3, 0xB0, 0xD6, 0xC4, 0x51, 0x43,
        0x49, 0x0E, 0x01, 0x33, 0x35, 0x9F, 0x05, 0x0B, 0xA5, 0xFE, 0x9B, 0xE6, 0xDD, 0x36, 0x15, 0x1F,
        0xD8, 0xDF, 0xDE, 0xD4, 0x19, 0xCB, 0xE6, 0xB2, 0x06, 0x6A, 0x3B, 0xBB, 0x02, 0x09, 0x6E, 0xBA,
        0xE9, 0x3B, 0xE0, 0xAB, 0x33, 0x72, 0xF6, 0x80, 0xBE, 0x96, 0xB2, 0x0E, 0x83, 0x82, 0x81, 0xC1,
        0x83, 0xA9, 0xED, 0x12, 0x3B, 0xB4, 0x84, 0x01, 0x75, 0x54, 0x8A, 0x39, 0x52, 0x8C, 0x43, 0xAC,
        0x0A, 0x41, 0xA6, 0x0C, 0xE7, 0x19, 0xD2, 0x8D, 0x4B, 0xAD, 0xA6, 0x61, 0x50, 0x9A, 0x4E, 0x2B,
        0x54, 0x97, 0x62, 0x72, 0x32, 0xBF, 0x10, 0xE7, 0xA2, 0xE5, 0x24, 0x63, 0x37, 0x39, 0x6B, 0x20,
        0xD0, 0x23, 0xAE, 0xF7, 0xA4, 0x15, 0xC8, 0xFC, 0x9B, 0x5C, 0x2B, 0x4D, 0x88, 0xC8, 0x20, 0x25
    };

    uint8_t PrivateExponent[] = {
        0x47, 0x33, 0x14, 0x2D, 0x85, 0x03, 0xDB, 0x69, 0x17, 0xCE, 0x7D, 0x9F, 0x20, 0xA6, 0xB1, 0x48,
        0x19, 0x49, 0x4D, 0x9B, 0x9C, 0x42, 0xAD, 0x7E, 0x50, 0x2A, 0xDA, 0xA1, 0x80, 0x1A, 0xA9, 0x7E,
        0xAC, 0x1D, 0x5B, 0xF6, 0xDB, 0x2F, 0xAC, 0x6C, 0xC2, 0x1A, 0xF4, 0xC9, 0xFB, 0x03, 0x44, 0x3C,
        0x32, 0xC2, 0x98, 0x09, 0x7D, 0x88, 0xD6, 0x11, 0x63, 0xA4, 0x09, 0x50, 0x0E, 0xD7, 0x36, 0xE5,
        0x8A, 0x31, 0x71, 0x47, 0x2F, 0xA5, 0x6C, 0x8C, 0x6D, 0x59, 0x33, 0x88, 0x9F, 0x14, 0xA8, 0xAB,
        0x1A, 0x7E, 0x83, 0x9F, 0x49, 0xE0, 0x01, 0xC4, 0xCE, 0x3A, 0xEC, 0x7E, 0xB4, 0x52, 0x4F, 0x59,
        0x90, 0xED, 0xC8, 0x6C, 0x6E, 0xD8, 0x0C, 0x9C, 0x71, 0x06, 0x9B, 0xC6, 0xD2, 0xD4, 0x00, 0x66,
        0x0F, 0x8B, 0xB7, 0xBD, 0xDC, 0x0E, 0x64, 0xD7, 0xDA, 0xA3, 0xFA, 0x28, 0x77, 0x78, 0x40, 0x69,
        0xDB, 0x9F, 0xA3, 0xDB, 0x9E, 0x48, 0x02, 0x56, 0x4C, 0x40, 0x94, 0x00, 0xAF, 0xE3, 0xF7, 0x1D,
        0x79, 0x30, 0x4D, 0x23, 0xD3, 0x14, 0xAC, 0xF2, 0x17, 0x73, 0x6B, 0x30, 0x1A, 0x68, 0x13, 0xA3,
        0xC8, 0x55, 0x6E, 0x12, 0x5C, 0x57, 0x90, 0x19, 0x3E, 0xFB, 0x5F, 0x28, 0x70, 0x69, 0x23, 0xC1,
        0xB3, 0xD6, 0x48, 0x89, 0x6A, 0x85, 0xCE, 0xB8, 0x1C, 0xAE, 0x4A, 0x9E, 0x80, 0x9F, 0x91, 0x8E,
        0x56, 0x94, 0xCC, 0x41, 0x39, 0xC4, 0x6A, 0x89, 0xF5, 0xE8, 0x99, 0x71, 0xFE, 0xF1, 0xFC, 0x6B,
        0xB9, 0x9C, 0xA6, 0xAC, 0xCD, 0x6B, 0x40, 0x7B, 0xC8, 0x16, 0xCD, 0xA6, 0xB4, 0x0D, 0x59, 0xB7,
        0x7A, 0xC8, 0x2B, 0xF6, 0x19, 0xEC, 0x0B, 0x23, 0x65, 0xF1, 0x43, 0xF8, 0x54, 0x30, 0x35, 0x21,
        0x63, 0x58, 0x11, 0x92, 0xEA, 0xA5, 0x2D, 0x67, 0xFB, 0x1E, 0x5F, 0xBC, 0xD2, 0xBF, 0x05, 0x81
    };

    uint8_t PublicExponent[] = { 0x00, 0x01, 0x00, 0x01 };
    uint8_t TModulus[] = { 0xb6, 0xf3, 0x4f, 0xf4, 0x27, 0xab, 0x0a, 0xef, 0x3e, 0x44, 0xe8, 0xd5, 0x51, 0x4a, 0x53, 0x1f, 0xed, 0xb1, 0x5b, 0x47, 0x72, 0xfa, 0x4e, 0xc4, 0x93, 0x15, 0x2e, 0xf2, 0x36, 0x74, 0x4b, 0xe4, 0x6f, 0x74, 0xf9, 0xf3, 0x68, 0x1a, 0x34, 0x9b, 0xae, 0xad, 0xed, 0x87, 0x2d, 0x63, 0xfa, 0xdf, 0xa6, 0xe3, 0x41, 0x52, 0xa1, 0xb7, 0x85, 0xb2, 0x6c, 0x38, 0xec, 0x56, 0xef, 0xe8, 0xc7, 0x0e, 0x6d, 0x6b, 0x36, 0x28, 0xc8, 0xdf, 0xd9, 0xad, 0x0b, 0x4f, 0xeb, 0x9b, 0x7f, 0xf7, 0x74, 0x40, 0xc5, 0x68, 0x0b, 0xd0, 0xe4, 0xe9, 0x1b, 0x2c, 0x15, 0x36, 0x84, 0x3e, 0x17, 0x08, 0x07, 0x37, 0x18, 0xcf, 0x6e, 0x11, 0x25, 0xc9, 0xbd, 0x85, 0xc7, 0xa3, 0xee, 0xdc, 0x9c, 0x2f, 0x5c, 0xcb, 0xb1, 0x55, 0xf1, 0x88, 0x0d, 0xcb, 0x13, 0xa3, 0x8d, 0x72, 0x96, 0x34, 0x32, 0x2e, 0x1a, 0xc2, 0x70, 0xfc, 0x0b, 0x1c, 0x0c, 0x3e, 0xb0, 0xa1, 0x7a, 0xaf, 0x15, 0x1a, 0x04, 0x52, 0x2e, 0xf6, 0xd9, 0x22, 0x46, 0xc8, 0x96, 0x11, 0x4a, 0xee, 0xd6, 0x60, 0xd2, 0xfc, 0x72, 0x60, 0x0a, 0xef, 0x64, 0x3f, 0x11, 0x67, 0xb3, 0x77, 0x7c, 0x9c, 0x03, 0x98, 0x71, 0x64, 0xe7, 0x56, 0x66, 0x2c, 0xf2, 0x02, 0x1d, 0x48, 0xe6, 0x91, 0xd4, 0x58, 0x40, 0x92, 0x6f, 0x5d, 0xb4, 0x42, 0x84, 0x60, 0x92, 0x22, 0x8a, 0x04, 0xa1, 0x4d, 0xde, 0xaa, 0x9c, 0x81, 0x4e, 0x3a, 0x34, 0x06, 0x31, 0x39, 0xbb, 0x2f, 0x6b, 0xb7, 0x01, 0x17, 0xc2, 0x83, 0x19, 0x30, 0x68, 0x38, 0x0b, 0x84, 0xf1, 0x7f, 0xbd, 0x24, 0xa1, 0xde, 0xc5, 0xc3, 0x44, 0x3c, 0x4b, 0x53, 0x58, 0x89, 0x28, 0x8f, 0x36, 0x30, 0xd8, 0x78, 0x48, 0x28, 0xf2, 0xd4, 0xfd, 0xd1, 0x36, 0xfb, 0xf1, 0xa8, 0x64, 0xa0, 0xc3, 0x8f };
    uint8_t PriEx[] =   { 0x96, 0x62, 0x54, 0xb3, 0x9e, 0xb3, 0xe3, 0x6e, 0x1b, 0x62, 0x6b, 0x7d, 0x85, 0xaf, 0xb1, 0xba, 0x8a, 0x19, 0x02, 0xae, 0x2d, 0x9e, 0x01, 0x87, 0x66, 0x5b, 0xc0, 0x56, 0x4b, 0x5a, 0xb7, 0x53, 0x94, 0x26, 0xb4, 0x9b, 0x57, 0x54, 0x4b, 0x30, 0x39, 0x9b, 0x30, 0xa7, 0xb0, 0x31, 0x01, 0xf4, 0x3b, 0xeb, 0x8c, 0x33, 0x8f, 0x49, 0x1a, 0xf6, 0x3a, 0x2d, 0x64, 0x60, 0x66, 0x1e, 0x93, 0x19, 0x91, 0xe9, 0xd2, 0x00, 0x1e, 0x76, 0x9b, 0x28, 0xba, 0x26, 0xbc, 0xc5, 0xfa, 0x9f, 0x7f, 0x09, 0x0a, 0xfb, 0xe6, 0xd2, 0x94, 0x87, 0xe4, 0xd5, 0x0c, 0xae, 0xde, 0x6f, 0x67, 0x61, 0x2b, 0x05, 0x28, 0x38, 0xc2, 0x02, 0x08, 0x6c, 0xd7, 0x84, 0x13, 0x41, 0xf6, 0xc3, 0x93, 0x02, 0xff, 0xa5, 0x54, 0x25, 0x10, 0x40, 0x45, 0x0e, 0x4c, 0x1b, 0x61, 0xd6, 0xf2, 0x0e, 0xff, 0xbc, 0x94, 0x33, 0x22, 0xee, 0xee, 0xed, 0xef, 0xfc, 0xf2, 0x65, 0xdf, 0x1e, 0x40, 0xca, 0x23, 0x0c, 0x3c, 0x96, 0xcc, 0xc5, 0x69, 0xa6, 0x83, 0xf8, 0xcb, 0xec, 0x02, 0xb8, 0x66, 0x84, 0xa6, 0xf3, 0xef, 0x11, 0x33, 0x37, 0x6b, 0x29, 0xf7, 0xe7, 0x32, 0xfc, 0x6e, 0x12, 0xb0, 0x4b, 0xba, 0xcc, 0x95, 0x61, 0xd3, 0x84, 0xbc, 0x44, 0x56, 0x94, 0x88, 0xd9, 0x4e, 0x1c, 0x5b, 0x5a, 0xf8, 0xea, 0x85, 0x5d, 0xd7, 0x38, 0x3b, 0xb0, 0x98, 0x65, 0xd3, 0x91, 0x71, 0xef, 0x25, 0xab, 0x8f, 0x81, 0x16, 0x09, 0x78, 0xbd, 0xb2, 0xd7, 0x82, 0xf8, 0xbc, 0x26, 0xdf, 0x35, 0x6c, 0x76, 0x15, 0x40, 0xbb, 0x91, 0x54, 0xd4, 0x91, 0x76, 0xe3, 0x85, 0xc2, 0x30, 0xa9, 0x80, 0x68, 0xb0, 0x4c, 0x3b, 0xd6, 0xf2, 0xed, 0x46, 0xe6, 0x1b, 0x95, 0xf6, 0xaf, 0x28, 0x0a, 0xfc, 0x6c, 0x3c, 0x64, 0x72, 0x24, 0x99 };
    uint8_t EncryptedData[] = { 0x0D, 0xDB, 0xCB, 0x4E, 0x75, 0xA3, 0xBD, 0xFE, 0x6E, 0xEB, 0x55, 0x59, 0xBE, 0x50, 0xB9, 0xA8, 0x9B, 0x2C, 0x52, 0x91, 0xF0, 0xF1, 0xEC, 0x5C, 0x10, 0x27, 0x7E, 0x50, 0x1C, 0x26, 0x03, 0xCE, 0x86, 0xF4, 0xEB, 0xC0, 0x25, 0x91, 0x33, 0x30, 0xC7, 0x81, 0x06, 0x93, 0xE9, 0xAC, 0xB2, 0xF7, 0xAA, 0xE3, 0x13, 0x7B, 0x56, 0x62, 0xCE, 0x76, 0x32, 0xB9, 0x7C, 0x5F, 0x9D, 0x28, 0x01, 0xCE, 0x7D, 0xA3, 0xAC, 0xD4, 0xBC, 0x9D, 0x76, 0x87, 0xE5, 0xF0, 0x6C, 0x75, 0xCD, 0x17, 0x60, 0x40, 0x66, 0x9D, 0xDE, 0x9B, 0x71, 0x12, 0xC2, 0x6A, 0x04, 0xB6, 0xCE, 0x39, 0x14, 0x3B, 0xD0, 0x05, 0xDD, 0x47, 0xCB, 0x68, 0xD1, 0x3B, 0x48, 0x0F, 0xE0, 0x8A, 0xD1, 0xE9, 0x42, 0xF0, 0xF2, 0x1F, 0x88, 0x36, 0x00, 0xD5, 0x65, 0xB9, 0x5C, 0x5E, 0xCB, 0x5E, 0xF6, 0x32, 0x1F, 0x92, 0x5A, 0xC2, 0x98, 0x35, 0xFD, 0xBF, 0x27, 0x98, 0xCE, 0x5F, 0x5A, 0xAF, 0x27, 0x3A, 0x5C, 0x71, 0x72, 0xB6, 0x5F, 0xAB, 0x64, 0xCB, 0xC5, 0x24, 0x70, 0xC2, 0xDD, 0xF6, 0x1A, 0x9A, 0x99, 0x1C, 0xF2, 0xE7, 0xB6, 0x3A, 0xA6, 0x70, 0x06, 0x76, 0x11, 0xCA, 0xA7, 0x2D, 0x89, 0x46, 0xC5, 0x72, 0x73, 0x0A, 0x1B, 0x99, 0x00, 0x75, 0x9A, 0x8B, 0xDD, 0xBE, 0x5F, 0xCF, 0x72, 0x8F, 0xA4, 0x67, 0x42, 0x2E, 0x70, 0x3E, 0xF5, 0x2C, 0x4A, 0x0A, 0x1F, 0x87, 0x33, 0xB3, 0xDB, 0x9D, 0xAF, 0x2F, 0x4E, 0xBD, 0xFE, 0x25, 0x28, 0xEC, 0xC0, 0xD7, 0xDF, 0xDE, 0x69, 0x84, 0xD3, 0xB4, 0x64, 0xBA, 0x1D, 0xA8, 0xEF, 0x7E, 0x31, 0x06, 0x93, 0xF5, 0x7D, 0xC2, 0x59, 0x1D, 0xD4, 0x92, 0x0D, 0x2B, 0xA4, 0x8B, 0x3E, 0x3E, 0x18, 0x41, 0x2D, 0x93, 0x60, 0xE3, 0x89, 0xC1, 0xCD, 0x1F, 0xE4, 0x8F, 0xAD, 0x90 };

    class TestKeySource : public IAuthenticationKeySource
    {
    public:
        virtual nn::Result GetPrivateKey1(Key2048 * pOut) override
        {
            std::memcpy(pOut->data, PrivateExponent, pOut->KEY_SIZE);
            NN_RESULT_SUCCESS;
        }
        virtual nn::Result GetPrivateKey3(Key2048 * pOut) override
        {
            std::memcpy(pOut->data, PrivateExponent, pOut->KEY_SIZE);
            NN_RESULT_SUCCESS;
        }
        virtual nn::Result GetPublicKey2(Key2048 * pOut) override
        {
            std::memcpy(pOut->data, Modulus, pOut->KEY_SIZE);
            NN_RESULT_SUCCESS;
        }
        virtual nn::Result GetPublicKey4(Key2048 * pOut) override
        {
            std::memcpy(pOut->data, Modulus, pOut->KEY_SIZE);
            NN_RESULT_SUCCESS;
        }
        virtual nn::Result GenerateSessionId(Id128 * pOut) override
        {
            pOut->data[0] = 0x12;
            pOut->data[1] = 0x34;
            NN_RESULT_SUCCESS;
        }
        virtual nn::Result GenerateOaepSeed(Sha256Hash * pOut) override
        {
            std::memset(pOut->data, 1, pOut->SIZE);
            pOut->data[0] = 0x12;
            NN_RESULT_SUCCESS;
        }
        virtual nn::Result GetPublicKey1(Key2048 * pOut) override
        {
            std::memcpy(pOut->data, Modulus, pOut->KEY_SIZE);
            NN_RESULT_SUCCESS;
        }
        virtual nn::Result GetPublicKey3(Key2048 * pOut) override
        {
            std::memcpy(pOut->data, Modulus, pOut->KEY_SIZE);
            NN_RESULT_SUCCESS;
        }
    };
}

class AuthenticationTest : public ::testing::Test
{
protected:
    virtual void SetUp()
    {
        if (GetTestEnv().IsManuEnabled())
        {
            m_FileSystem = GetTestEnv().GetManuFileSystem();
            NN_ABORT_UNLESS_RESULT_SUCCESS(
                nn::repair::CreateProtectedFileEncryptor(&m_Encryptor, "Spl"));
        }
        else
        {
            m_FileSystem = GetTestEnv().GetNnfsFileSystem();
            NN_ABORT_UNLESS_RESULT_SUCCESS(
                nn::repair::CreateProtectedFileEncryptor(&m_Encryptor, "FixedKey"));
        }

        filename = GetTestEnv().GetWorkingDirectory() + "/test.bin";
        nn::fs::DeleteFile(filename.c_str());
    }

    virtual void TearDown()
    {

    }

    std::shared_ptr<FileSystem> m_FileSystem;
    std::shared_ptr<nn::repair::IProtectedFileEncryptor> m_Encryptor;

    std::string filename;
};

TEST_F(AuthenticationTest, TestDecode)
{
    uint8_t result[32] = {1,2,3};
    uint8_t expected[32] = {};

    nn::crypto::RsaOaepDecryptor<Key2048::KEY_SIZE, nn::crypto::Sha256Generator> decriptor;
    decriptor.Initialize(TModulus, sizeof(TModulus),
        PriEx, sizeof(PriEx));
    decriptor.UpdateLabel("", 0);

    auto size = decriptor.Decrypt(result, sizeof(result), EncryptedData, sizeof(EncryptedData));
    EXPECT_EQ(32, size);
    EXPECT_EQ(0, std::memcmp(expected, result, sizeof(result)));

    for (int i = 0; i < 32;i++)
    {
        NN_LOG("%02x", i, result[i]);
    }
    NN_LOG("\n");

    nn::crypto::RsaOaepEncryptor<Key2048::KEY_SIZE, nn::crypto::Sha256Generator> encrpytor;

    uint8_t message[32] = { 1, 2, 3, 4, 4, 3, 2, 1, 1, 2, 3, 4, 4, 3, 2, 1, 1, 2, 3, 4, 4, 3, 2, 1, 1, 2, 3, 4, 4, 3, 2, 1 };
    uint8_t encrypted[256] = {};

    encrpytor.Initialize(
        TModulus, sizeof(TModulus),
        PublicExponent, sizeof(PublicExponent));
    encrpytor.UpdateLabel("", 0);

    Sha256Hash seed = {};

    encrpytor.Encrypt(
        encrypted, sizeof(encrypted),
        message, sizeof(message),
        seed.data, seed.SIZE);

    NN_LOG("Encrypted: ");
    for (int i = 0; i < 256; i++)
    {
        NN_LOG("%02x", encrypted[i]);
    }
    NN_LOG("\n");
}

TEST_F(AuthenticationTest, Basic)
{
    std::shared_ptr<IAuthenticationKeySource> keySource(new TestKeySource());

    {
        nn::repair::RepairAuthentication auth;
        auth.Initialize(keySource);

        Id128 sessionId = {};
        sessionId.data[0] = 0x12;
        sessionId.data[1] = 0x34;

        Key128 key = {};
        key.data[0] = 0x12;

        BackupRequestMessage message;

        NNT_EXPECT_RESULT_SUCCESS(
            auth.MakeBackupRequestMessage(&message, sessionId, key));
    }
}

#if defined(NN_BUILD_CONFIG_OS_HORIZON)

#endif
