﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Linq;
using System.Security.Cryptography;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace RepairToolsHost
{
    [TestClass]
    public class UnitTest1
    {
        [TestMethod]
        public void TestMethod1()
        {
            var rsa = new RSACryptoServiceProvider(2048);

            var param = rsa.ExportParameters(true);

            Console.WriteLine("Modulus: {0}", string.Join(", ",  from x in param.Modulus select string.Format("0x{0:X2}", x)));
            Console.WriteLine("publicExponent: {0}", string.Join(", ", from x in param.Exponent select string.Format("0x{0:X2}", x)));
            Console.WriteLine("privateExponent: {0}", string.Join(", ", from x in param.D select string.Format("0x{0:X2}", x)));
        }
    }
}
