﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.Property
{
    public class PropertyUseDebugLibraries : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsWinPlatform)
            {
                return;
            }
            if (conf.SubRootName == "Users")
            {
                // don't care
                return;
            }

            switch (conf.BuildType)
            {
                case "Debug":
                    Assert.Equal("true", ep.Properties["UseDebugLibraries"]);
                    break;
                case "Develop":
                    Assert.Equal("false", ep.Properties["UseDebugLibraries"]);
                    break;
                case "Release":
                    Assert.Equal("false", ep.Properties["UseDebugLibraries"]);
                    break;
                default:
                    Assert.True(false, string.Format("未知の BuildType です: {0}", conf.BuildType));
                    break;
            }
        }
    }
}
