﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.Property
{
    public class PropertyOutDir : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (SdkRootInfo.Environment)
            {
                case SdkEnvironment.Development:
                    InvokeDevelopmentEnvironmentAssertions(conf, ep, expander);
                    break;
                case SdkEnvironment.User:
                    InvokeUserEnvironmentAssertions(conf, ep, expander);
                    break;
                default:
                    Assert.True(false, string.Format("未知の SDK 環境です: {0}", SdkRootInfo.Environment));
                    break;
            }
        }

        private void InvokeDevelopmentEnvironmentAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.ProjectType)
            {
                case ProjectType.Library:
                case ProjectType.DynamicLibrary:
                    AssertArePathsEqual(expander,
                        @"$(SdkRoot)\$(SubRootRelativeDir)\Libraries\$(BuildTarget)\$(BuildType)",
                        ep.Properties["OutDir"]);
                    break;
                case ProjectType.Program:
                case ProjectType.ProgramWithoutSdkNso:
                case ProjectType.SystemProgram:
                    switch (conf.SubRootName)
                    {
                        case "Alice":
                        case "Chris":
                        case "Eris":
                        case "Iris":
                        case "NintendoWare":
                            AssertArePathsEqual(expander,
                                @"$(SdkRoot)\$(SubRootRelativeDir)\Outputs\$(BuildTarget)\$(NintendoSdkProgramCategory)\$(TargetName)\$(BuildType)",
                                ep.Properties["OutDir"]);
                            break;
                        case "Samples":
                            AssertArePathsEqual(expander,
                                @"$(SdkRoot)\$(SubRootRelativeDir)\Outputs\$(BuildTarget)\Applications\$(TargetName)\$(BuildType)",
                                ep.Properties["OutDir"]);
                            break;
                        case "Tests":
                            AssertArePathsEqual(expander,
                                @"$(SdkRoot)\$(SubRootRelativeDir)\Outputs\$(BuildTarget)\Tests\$(TargetName)\$(BuildType)",
                                ep.Properties["OutDir"]);
                            break;
                        case "Users":
                            // don't care
                            break;
                        default:
                            Assert.True(false, string.Format("{0}: 未知の SubRootName です。", conf.SubRootName));
                            break;
                    }
                    break;
                default:
                    Assert.True(false, string.Format("未知の ProjectType です: {0}", conf.ProjectType));
                    break;
            }
        }

        private void InvokeUserEnvironmentAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.SubRootName)
            {
                case "Samples":
                    switch (conf.ProjectType)
                    {
                        case ProjectType.Library:
                        case ProjectType.DynamicLibrary:
                            AssertArePathsEqual(expander,
                                @"$(SdkRoot)\$(SubRootRelativeDir)\Libraries\$(BuildTarget)\$(BuildType)",
                                ep.Properties["OutDir"]);
                            break;
                        case ProjectType.Program:
                        case ProjectType.ProgramWithoutSdkNso:
                        case ProjectType.SystemProgram:
                            AssertArePathsEqual(expander,
                                @"$(ProjectDir)\Binaries\$(Platform)\$(Configuration)",
                                ep.Properties["OutDir"]);
                            break;
                        default:
                            Assert.True(false, string.Format("未知の ProjectType です: {0}", conf.ProjectType));
                            break;
                    }
                    break;
                case "Iris":
                case "NintendoWare":
                    InvokeDevelopmentEnvironmentAssertions(conf, ep, expander);
                    break;
                case "Users":
                    // don't care で良いと思うが、意図せず値が変わっていないことをテストする
                    if (conf.Platform == "Win32")
                    {
                        AssertArePathsEqual(expander,
                            @"$(ProjectDir)\$(Configuration)\",
                            ep.Properties["OutDir"]);
                    }
                    else if (conf.Platform == "NX32" || conf.Platform == "NX64")
                    {
                        AssertArePathsEqual(expander,
                            @"$(Platform)\$(Configuration)\",  // 本来は $(SolutionDir)\$(Platform)\$(Configuration)\
                            ep.Properties["OutDir"]);
                    }
                    else
                    {
                        AssertArePathsEqual(expander,
                            @"$(ProjectDir)\$(Platform)\$(Configuration)\",
                            ep.Properties["OutDir"]);
                    }
                    break;
                default:
                    Assert.True(false, string.Format("SDK 利用者環境では使用されない SubRootName か、もしくは未知の SubRootName です: {0}", conf.SubRootName));
                    break;
            }
        }
    }
}
