﻿using System;
using System.Text.RegularExpressions;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.Property
{
    public class PropertyNintendoSdkNXAddonVersion : PropertySheetsTest
    {
        // 何らかの数値が取得できれば OK とする
        private static readonly Regex s_NumberPattern = new Regex(@"^\d+$", RegexOptions.Compiled);

        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (conf.Spec != "NX")
            {
                return;
            }

            switch (conf.SubRootName)
            {
                case "Alice":
                case "Chris":
                case "Eris":
                case "Iris":
                case "NintendoWare":
                case "Tests":
                    // don't care
                    break;
                case "Samples":
                case "Users":
                    Assert.True(s_NumberPattern.IsMatch(ep.Properties["NintendoSdkNXAddonVersionMajor"]));
                    Assert.True(s_NumberPattern.IsMatch(ep.Properties["NintendoSdkNXAddonVersionMinor"]));
                    Assert.True(s_NumberPattern.IsMatch(ep.Properties["NintendoSdkNXAddonVersionMicro"]));
                    Assert.True(s_NumberPattern.IsMatch(ep.Properties["NintendoSdkNXAddonVersionReleaseStep"]));
                    break;
                default:
                    Assert.True(false, string.Format("未知の SubRootName です: {0}", conf.SubRootName));
                    break;
            }
        }
    }
}
