﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class LinkFinalizeMetaSource : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsNXPlatform)
            {
                return;
            }
            if (conf.ProjectType == ProjectType.Library)
            {
                return;
            }

            switch (conf.SubRootName)
            {
                case "Alice":
                case "Chris":
                case "Eris":
                case "Iris":
                case "NintendoWare":
                case "Tests":
                    // don't care
                    break;
                case "Samples":
                    switch (SdkRootInfo.Environment)
                    {
                        case SdkEnvironment.Development:
                            InvokeDevelopmentEnvironmentAssertions(conf, ep, expander);
                            break;
                        case SdkEnvironment.User:
                            InvokeUserEnvironmentAssertions(conf, ep, expander);
                            break;
                        default:
                            Assert.True(false, string.Format("未知の SdkEnvironment です: {0}", SdkRootInfo.Environment));
                            break;
                    }
                    break;
                case "Users":
                    InvokeUserEnvironmentAssertions(conf, ep, expander);
                    break;
                default:
                    Assert.True(false, string.Format("未知の SubRootName です: {0}", conf.SubRootName));
                    break;
            }
        }

        private void InvokeDevelopmentEnvironmentAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.Platform)
            {
                case "NX32":
                    AssertMsBuildValueEqualsPaths(expander,
                        ep.Metadata["Link.FinalizeMetaSource"],
                        @"$(SdkRoot)\Programs\Iris\Resources\SpecFiles\Application.arm.ilp32.nmeta");
                    break;
                case "NX64":
                    AssertMsBuildValueEqualsPaths(expander,
                        ep.Metadata["Link.FinalizeMetaSource"],
                        @"$(SdkRoot)\Programs\Iris\Resources\SpecFiles\Application.aarch64.lp64.nmeta");
                    break;
                default:
                    Assert.True(false, string.Format("Platform が NX32 でも NX64 でもありません: {0}", conf.Platform));
                    break;
            }
        }

        private void InvokeUserEnvironmentAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.Platform)
            {
                case "NX32":
                    AssertMsBuildValueEqualsPaths(expander,
                        ep.Metadata["Link.FinalizeMetaSource"],
                        @"$(SdkRoot)\Resources\SpecFiles\Application.arm.ilp32.nmeta");
                    break;
                case "NX64":
                    AssertMsBuildValueEqualsPaths(expander,
                        ep.Metadata["Link.FinalizeMetaSource"],
                        @"$(SdkRoot)\Resources\SpecFiles\Application.aarch64.lp64.nmeta");
                    break;
                default:
                    Assert.True(false, string.Format("Platform が NX32 でも NX64 でもありません: {0}", conf.Platform));
                    break;
            }
        }
    }
}
