﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class LinkExportDynamic : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsNXPlatform)
            {
                return;
            }

            switch (conf.ProjectType)
            {
                case ProjectType.Library:
                    // don't care
                    break;
                case ProjectType.DynamicLibrary:
                case ProjectType.Program:
                case ProjectType.ProgramWithoutSdkNso:
                    Assert.Equal("true", ep.Metadata["Link.ExportDynamic"]);
                    break;
                case ProjectType.SystemProgram:
                    Assert.Equal("false", ep.Metadata["Link.ExportDynamic"]);
                    break;
                default:
                    Assert.True(false, string.Format($"未知の ProjectType です: {conf.ProjectType}"));
                    break;
            }
        }
    }
}
