﻿using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class LinkAdditionalDependencies : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (conf.ProjectType == ProjectType.Library)
            {
                return;
            }

            switch (conf.Platform)
            {
                case "Win32":
                case "x64":
                    InvokeWinPlatformAssertions(conf, ep, expander);
                    break;
                case "NX32":
                case "NX64":
                    InvokeNXPlatformAssertions(conf, ep, expander);
                    break;
                default:
                    Assert.True(false, string.Format("未知の Platform です: {0}", conf.Platform));
                    break;
            }
        }

        private void InvokeWinPlatformAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.SubRootName)
            {
                case "Alice":
                case "Chris":
                case "Eris":
                case "Iris":
                case "NintendoWare":
                case "Tests":
                    // don't care
                    break;
                case "Samples":
                case "Users":
                    AssertMsBuildValueContainsAnyElement(expander,
                        ep.Metadata["Link.AdditionalDependencies"],
                        "libnn_diagTextPublicEn.lib;libnn_diagTextPublicJp.lib");
                    // 以下のページの情報に基づく
                    // http://spdlybra.nintendo.co.jp/confluence/pages/viewpage.action?pageId=95685382
                    AssertMsBuildValueContainsElements(expander,
                        ep.Metadata["Link.AdditionalDependencies"],
                        "libnn_init.lib;"
                        + "libnn_os.lib;"
                        + "libnn_fs.lib;"
                        + "libnn_fssrv.lib;"
                        + "libnn_fssystem.lib;"
                        + "libnn_time.lib;"
                        + "libnn_timesrv.lib;"
                        + "libnn_util.lib;"
                        + "libnn_mem.lib;"
                        + "libnn_lmem.lib;"
                        + "libnn_crypto.lib;"
                        + "libnn_diag.lib;"
                        + "libnn_htcs.lib;"
                        + "libnn_htc.lib;"
                        + "libnn_settings.lib;"
                        + "libnn_hid.lib;"
                        + "libnn_audio.lib;"
                        + "libnn_gfx.lib;"
                        + "libnn_socket.lib;"
                        + "libnn_ssl.lib;"
                        + "libnn_nifm.lib");
                    break;
                default:
                    Assert.True(false, string.Format("未知の SubRootName です: {0}", conf.SubRootName));
                    break;
            }
        }

        private void InvokeNXPlatformAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            switch (conf.SubRootName)
            {
                case "Alice":
                case "Chris":
                case "Eris":
                    // don't care
                    break;
                case "Iris":
                case "NintendoWare":
                case "Tests":
                case "Samples":
                case "Users":
                    switch (conf.ProjectType)
                    {
                        case ProjectType.Library:
                            // don't care
                            break;
                        case ProjectType.DynamicLibrary:
                            AssertUtil.AssertSequenceEqual(
                                Util.SplitMsBuildValue(ep.Metadata["Link.AdditionalDependencies"]),
                                Enumerable.Empty<string>());
                            break;
                        case ProjectType.Program:
                            // 以下のページの情報に基づく
                            // http://spdlybra.nintendo.co.jp/confluence/pages/viewpage.action?pageId=95685382
                            if (conf.BuildType == "Release")
                            {
                                AssertMsBuildValueContainsAnyElement(expander,
                                    ep.Metadata["Link.AdditionalDependencies"],
                                    "nnSdk.nss");
                            }
                            else
                            {
                                AssertMsBuildValueContainsAnyElement(expander,
                                    ep.Metadata["Link.AdditionalDependencies"],
                                    "nnSdkEn.nss;nnSdkJp.nss");
                            }
                            break;
                        case ProjectType.ProgramWithoutSdkNso:
                            AssertMsBuildValueContainsElements(expander,
                                ep.Metadata["Link.AdditionalDependencies"],
                                "nnSdkEmpty.nss");
                            break;
                        case ProjectType.SystemProgram:
                            switch (SdkRootInfo.Environment)
                            {
                                case SdkEnvironment.Development:
                                    AssertUtil.AssertSequenceEqual(
                                        Util.SplitMsBuildValue(ep.Metadata["Link.AdditionalDependencies"]),
                                        Enumerable.Empty<string>());
                                    break;
                                case SdkEnvironment.User:
                                    AssertMsBuildValueContainsElements(expander,
                                        ep.Metadata["Link.AdditionalDependencies"],
                                        "libc.a;"
                                        + "libc++.a;"
                                        + "libc++abi.a;"
                                        + "libcompiler_rt.a;"
                                        + "libshim.a;"
                                        + "libunwind.a");
                                    break;
                            }
                            break;
                        default:
                            Assert.True(false, string.Format($"未知の ProjectType です: {conf.ProjectType}"));
                            break;
                    }
                    break;
                default:
                    Assert.True(false, string.Format("未知の SubRootName です: {0}", conf.SubRootName));
                    break;
            }
        }
    }
}
