﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class ClCompileOptimizationLevel : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsNXPlatform)
            {
                return;
            }

            switch (conf.BuildType)
            {
                case "Debug":
                    Assert.Equal("O0", ep.Metadata["ClCompile.OptimizationLevel"]);
                    break;
                case "Develop":
                case "Release":
                    Assert.Equal("O3", ep.Metadata["ClCompile.OptimizationLevel"]);
                    break;
                default:
                    Assert.True(false, string.Format("未知の BuildType です: {0}", conf.BuildType));
                    break;
            }
        }
    }
}
