﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class ClCompileOmitFramePointer : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsNXPlatform)
            {
                return;
            }

            switch (conf.BuildType)
            {
                case "Debug":
                case "Develop":
                    Assert.Equal("false", ep.Metadata["ClCompile.OmitFramePointer"]);
                    break;
                case "Release":
                    Assert.Equal("true", ep.Metadata["ClCompile.OmitFramePointer"]);
                    break;
                default:
                    Assert.True(false, string.Format("未知の BuildType です: {0}", conf.BuildType));
                    break;
            }
        }
    }
}
