﻿using System;
using System.Text;
using System.Collections.Generic;
using Xunit;

namespace PropertySheetsTest.TestCase.ItemMetadata
{
    public class ClCompileInlinefunctions : PropertySheetsTest
    {
        protected override void InvokeAssertions(TestConfiguration conf, EvaluatedVcProject ep, Expander expander)
        {
            if (!conf.IsNXPlatform)
            {
                return;
            }

            switch (conf.BuildType)
            {
                case "Debug":
                    Assert.Equal("false", ep.Metadata["ClCompile.Inlinefunctions"]);
                    break;
                case "Develop":
                case "Release":
                    Assert.Equal("true", ep.Metadata["ClCompile.Inlinefunctions"]);
                    break;
                default:
                    Assert.True(false, string.Format("未知の BuildType です: {0}", conf.BuildType));
                    break;
            }
        }
    }
}
