﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

struct RegisterForAlc5639
{
    bool isPrivate;
    uint32_t address;
};

struct TestPatternForAlc5639
{
    RegisterForAlc5639 reg;
    uint16_t expectValue;
};

// Initialized
static const TestPatternForAlc5639 testPattern_00[] = {
    { { false, 0x00 }, 0x0008 },
    { { false, 0x00 }, 0x0008 },
    { { false, 0x01 }, 0x8484 },
    { { false, 0x02 }, 0x1111 },
    { { false, 0x03 }, 0xC8C8 },
    { { false, 0x0D }, 0x5000 },
    { { false, 0x0E }, 0x0000 },
    { { false, 0x0F }, 0x0808 },
    { { false, 0x19 }, 0x0000 },
    { { false, 0x1C }, 0x1F80 },
    { { false, 0x1D }, 0x2F2F },
    { { false, 0x1E }, 0x0000 },
    { { false, 0x27 }, 0x3060 },
    { { false, 0x28 }, 0x7070 },
    { { false, 0x29 }, 0x8080 },
    { { false, 0x2A }, 0x1414 },
    { { false, 0x2B }, 0x5454 },
    { { false, 0x2C }, 0xAA00 },
    { { false, 0x2F }, 0x2000 },
    { { false, 0x3B }, 0x0000 },
    { { false, 0x3C }, 0x007F },
    { { false, 0x3D }, 0x0000 },
    { { false, 0x3E }, 0x007F },
    { { false, 0x45 }, 0xC000 },
    { { false, 0x46 }, 0x0036 },
    { { false, 0x47 }, 0x0036 },
    { { false, 0x48 }, 0xE800 },
    { { false, 0x49 }, 0x2800 },
    { { false, 0x4A }, 0x0004 },
    { { false, 0x4D }, 0x0000 },
    { { false, 0x4E }, 0x0000 },
    { { false, 0x4F }, 0x01FE },
    { { false, 0x50 }, 0x0000 },
    { { false, 0x51 }, 0x0000 },
    { { false, 0x52 }, 0x01FE },
    { { false, 0x53 }, 0xF000 },
    { { false, 0x61 }, 0x8001 },
    { { false, 0x62 }, 0x0000 },
    { { false, 0x63 }, 0xE818 },
    { { false, 0x64 }, 0x0000 },
    { { false, 0x65 }, 0x3000 },
    { { false, 0x66 }, 0xC000 },
    // { { false, 0x6A }, 0x0037 },
    // { { false, 0x6C }, 0xFC00 },
    { { false, 0x70 }, 0x8000 },
    { { false, 0x71 }, 0x8000 },
    { { false, 0x73 }, 0x8814 },
    { { false, 0x75 }, 0x1D00 },
    { { false, 0x80 }, 0x0000 },
    { { false, 0x81 }, 0x0000 },
    { { false, 0x82 }, 0x0000 },
    { { false, 0x83 }, 0x0000 },
    { { false, 0x84 }, 0x0000 },
    { { false, 0x85 }, 0x0008 },
    { { false, 0x89 }, 0x0000 },
    { { false, 0x8A }, 0x0000 },
    { { false, 0x8C }, 0x0328 },
    { { false, 0x8D }, 0xA800 },
    { { false, 0x8E }, 0x0004 },
    { { false, 0x8F }, 0x1100 },
    { { false, 0x90 }, 0x0646 },
    { { false, 0x91 }, 0x0C00 },
    { { false, 0x92 }, 0x0000 },
    { { false, 0x93 }, 0x3800 },
    { { false, 0xB0 }, 0x2080 },
    { { false, 0xB1 }, 0x0000 },
    { { false, 0xB4 }, 0x2206 },
    { { false, 0xB5 }, 0x1F00 },
    { { false, 0xB6 }, 0x0000 },
    { { false, 0xBB }, 0x0000 },
    { { false, 0xBD }, 0x4000 },
    { { false, 0xBE }, 0x8000 },
    { { false, 0xBF }, 0x0000 },
    { { false, 0xC0 }, 0x8400 },
    { { false, 0xC2 }, 0x0004 },
    { { false, 0xC8 }, 0x0000 },
    { { false, 0xC9 }, 0x0000 },
    { { false, 0xCA }, 0x0000 },
    { { false, 0xCB }, 0x0000 },
    { { false, 0xCC }, 0x0000 },
    { { false, 0xD3 }, 0x2A20 },
    { { false, 0xD6 }, 0x0400 },
    { { false, 0xD9 }, 0x0809 },
    { { false, 0xFA }, 0x3E01 },
    { { false, 0xFB }, 0x0000 },
    { { false, 0xFE }, 0x10EC },
    { { true, 0x12 }, 0x0AA8 },
    { { true, 0x14 }, 0x8AAA },
    { { true, 0x1B }, 0x0200 },
    { { true, 0x1D }, 0x0347 },
    { { true, 0x20 }, 0x6110 },
    { { true, 0x23 }, 0x0804 },
    { { true, 0x37 }, 0xFC00 },
    { { true, 0x3A }, 0x4002 },
    { { true, 0x3D }, 0x3600 },
    { { true, 0x6E }, 0x3019 },
    { { true, 0x77 }, 0x1F00 },
    { { true, 0x90 }, 0x2000 },
    { { true, 0x91 }, 0x1000 },
    { { true, 0xA0 }, 0x1C10 },
    { { true, 0xA1 }, 0x01F4 },
    { { true, 0xA2 }, 0xC5E9 },
    { { true, 0xA3 }, 0x1A98 },
    { { true, 0xA4 }, 0x1D2C },
    { { true, 0xA5 }, 0xC882 },
    { { true, 0xA6 }, 0x1C10 },
    { { true, 0xA7 }, 0x01F4 },
    { { true, 0xA8 }, 0xE904 },
    { { true, 0xA9 }, 0x1C10 },
    { { true, 0xAA }, 0x01F4 },
    { { true, 0xAB }, 0xE904 },
    { { true, 0xAC }, 0x1C10 },
    { { true, 0xAD }, 0x01F4 },
    { { true, 0xAE }, 0x1C10 },
    { { true, 0xAF }, 0x01F4 },
    { { true, 0xB0 }, 0x2000 },
    { { true, 0xB1 }, 0x0000 },
    { { true, 0xB2 }, 0x2000 },
};

// SetSpeakerMute(false)
static const TestPatternForAlc5639 testPattern_01[] = {
    { { false, 0x00 }, 0x0008 },
    { { false, 0x00 }, 0x0008 },
    { { false, 0x01 }, 0x8484 },
    { { false, 0x02 }, 0x1111 },
    { { false, 0x03 }, 0xC8C8 },
    { { false, 0x0D }, 0x5000 },
    { { false, 0x0E }, 0x0000 },
    { { false, 0x0F }, 0x0808 },
    { { false, 0x19 }, 0x0000 },
    { { false, 0x1C }, 0x1F80 },
    { { false, 0x1D }, 0x2F2F },
    { { false, 0x1E }, 0x0000 },
    { { false, 0x27 }, 0x3060 },
    { { false, 0x28 }, 0x7070 },
    { { false, 0x29 }, 0x8080 },
    { { false, 0x2A }, 0x1414 },
    { { false, 0x2B }, 0x5454 },
    { { false, 0x2C }, 0xAA00 },
    { { false, 0x2F }, 0x2000 },
    { { false, 0x3B }, 0x0000 },
    { { false, 0x3C }, 0x007F },
    { { false, 0x3D }, 0x0000 },
    { { false, 0x3E }, 0x007F },
    { { false, 0x45 }, 0xC000 },
    { { false, 0x46 }, 0x0036 },
    { { false, 0x47 }, 0x0036 },
    { { false, 0x48 }, 0xE800 },
    { { false, 0x49 }, 0x2800 },
    { { false, 0x4A }, 0x0004 },
    { { false, 0x4D }, 0x0000 },
    { { false, 0x4E }, 0x0000 },
    { { false, 0x4F }, 0x01FE },
    { { false, 0x50 }, 0x0000 },
    { { false, 0x51 }, 0x0000 },
    { { false, 0x52 }, 0x01FE },
    { { false, 0x53 }, 0xF000 },
    { { false, 0x61 }, 0x8000 },
    { { false, 0x62 }, 0x0000 },
    { { false, 0x63 }, 0xE8F8 },
    { { false, 0x64 }, 0x0000 },
    { { false, 0x65 }, 0xC000 },
    { { false, 0x66 }, 0x0C00 },
    // { { false, 0x6A }, 0x00B4 },
    // { { false, 0x6C }, 0x0800 },
    { { false, 0x70 }, 0x8000 },
    { { false, 0x71 }, 0x8000 },
    { { false, 0x73 }, 0x8814 },
    { { false, 0x75 }, 0x1D00 },
    { { false, 0x80 }, 0x0000 },
    { { false, 0x81 }, 0x0000 },
    { { false, 0x82 }, 0x0000 },
    { { false, 0x83 }, 0x0000 },
    { { false, 0x84 }, 0x0000 },
    { { false, 0x85 }, 0x0008 },
    { { false, 0x89 }, 0x0000 },
    { { false, 0x8A }, 0x0000 },
    { { false, 0x8C }, 0x0328 },
    { { false, 0x8D }, 0xA800 },
    { { false, 0x8E }, 0x8019 },
    { { false, 0x8F }, 0x3100 },
    { { false, 0x90 }, 0x0737 },
    { { false, 0x91 }, 0x0E00 },
    { { false, 0x92 }, 0x0000 },
    { { false, 0x93 }, 0x3800 },
    { { false, 0xB0 }, 0xE000 },
    { { false, 0xB1 }, 0x0040 },
    { { false, 0xB4 }, 0x2206 },
    { { false, 0xB5 }, 0x1F00 },
    { { false, 0xB6 }, 0x0000 },
    { { false, 0xBB }, 0x0000 },
    { { false, 0xBD }, 0x4000 },
    { { false, 0xBE }, 0x8000 },
    { { false, 0xBF }, 0x0000 },
    { { false, 0xC0 }, 0x8400 },
    { { false, 0xC2 }, 0x0004 },
    { { false, 0xC8 }, 0x0000 },
    { { false, 0xC9 }, 0x0000 },
    { { false, 0xCA }, 0x0000 },
    { { false, 0xCB }, 0x0000 },
    { { false, 0xCC }, 0x0000 },
    { { false, 0xD3 }, 0x2A20 },
    { { false, 0xD6 }, 0x0400 },
    { { false, 0xD9 }, 0x0809 },
    { { false, 0xFA }, 0x3E01 },
    { { false, 0xFB }, 0x0000 },
    { { false, 0xFE }, 0x10EC },
    { { true, 0x12 }, 0x0AA8 },
    { { true, 0x14 }, 0x8AAA },
    { { true, 0x1B }, 0x0200 },
    { { true, 0x1D }, 0x0347 },
    { { true, 0x20 }, 0x6110 },
    { { true, 0x23 }, 0x0804 },
    { { true, 0x37 }, 0xFC00 },
    { { true, 0x3A }, 0x4002 },
    { { true, 0x3D }, 0x3600 },
    { { true, 0x6E }, 0x3019 },
    { { true, 0x77 }, 0x1F00 },
    { { true, 0x90 }, 0x2000 },
    { { true, 0x91 }, 0x1000 },
    { { true, 0xA0 }, 0x1C10 },
    { { true, 0xA1 }, 0x01F4 },
    { { true, 0xA2 }, 0xC5E9 },
    { { true, 0xA3 }, 0x1A98 },
    { { true, 0xA4 }, 0x1D2C },
    { { true, 0xA5 }, 0xC882 },
    { { true, 0xA6 }, 0x1C10 },
    { { true, 0xA7 }, 0x01F4 },
    { { true, 0xA8 }, 0xE904 },
    { { true, 0xA9 }, 0x1C10 },
    { { true, 0xAA }, 0x01F4 },
    { { true, 0xAB }, 0xE904 },
    { { true, 0xAC }, 0x1C10 },
    { { true, 0xAD }, 0x01F4 },
    { { true, 0xAE }, 0x1C10 },
    { { true, 0xAF }, 0x01F4 },
    { { true, 0xB0 }, 0x1F68 },
    { { true, 0xB1 }, 0x0094 },
    { { true, 0xB2 }, 0x1F69 },
};

// SetSpeakerMute(false) -> SetOutVolume(0)
static const TestPatternForAlc5639 testPattern_02[] = {
    { { false, 0x00 }, 0x0008 },
    { { false, 0x00 }, 0x0008 },
    { { false, 0x01 }, 0x8484 },
    { { false, 0x02 }, 0x1111 },
    { { false, 0x03 }, 0xC8C8 },
    { { false, 0x0D }, 0x5000 },
    { { false, 0x0E }, 0x0000 },
    { { false, 0x0F }, 0x0808 },
    { { false, 0x19 }, 0x0000 },
    { { false, 0x1C }, 0x1F80 },
    { { false, 0x1D }, 0x2F2F },
    { { false, 0x1E }, 0x0000 },
    { { false, 0x27 }, 0x3060 },
    { { false, 0x28 }, 0x7070 },
    { { false, 0x29 }, 0x8080 },
    { { false, 0x2A }, 0x1414 },
    { { false, 0x2B }, 0x5454 },
    { { false, 0x2C }, 0xAA00 },
    { { false, 0x2F }, 0x2000 },
    { { false, 0x3B }, 0x0000 },
    { { false, 0x3C }, 0x007F },
    { { false, 0x3D }, 0x0000 },
    { { false, 0x3E }, 0x007F },
    { { false, 0x45 }, 0xC000 },
    { { false, 0x46 }, 0x0036 },
    { { false, 0x47 }, 0x0036 },
    { { false, 0x48 }, 0xE800 },
    { { false, 0x49 }, 0x2800 },
    { { false, 0x4A }, 0x0004 },
    { { false, 0x4D }, 0x0000 },
    { { false, 0x4E }, 0x0000 },
    { { false, 0x4F }, 0x01FE },
    { { false, 0x50 }, 0x0000 },
    { { false, 0x51 }, 0x0000 },
    { { false, 0x52 }, 0x01FE },
    { { false, 0x53 }, 0xF000 },
    { { false, 0x61 }, 0x8000 },
    { { false, 0x62 }, 0x0000 },
    { { false, 0x63 }, 0xE8F8 },
    { { false, 0x64 }, 0x0000 },
    { { false, 0x65 }, 0xC000 },
    { { false, 0x66 }, 0x0C00 },
    // { { false, 0x6A }, 0x00B2 },
    // { { false, 0x6C }, 0x1F69 },
    { { false, 0x70 }, 0x8000 },
    { { false, 0x71 }, 0x8000 },
    { { false, 0x73 }, 0x8814 },
    { { false, 0x75 }, 0x1D00 },
    { { false, 0x80 }, 0x0000 },
    { { false, 0x81 }, 0x0000 },
    { { false, 0x82 }, 0x0000 },
    { { false, 0x83 }, 0x0000 },
    { { false, 0x84 }, 0x0000 },
    { { false, 0x85 }, 0x0008 },
    { { false, 0x89 }, 0x0000 },
    { { false, 0x8A }, 0x0000 },
    { { false, 0x8C }, 0x0328 },
    { { false, 0x8D }, 0xA800 },
    { { false, 0x8E }, 0x8019 },
    { { false, 0x8F }, 0x3100 },
    { { false, 0x90 }, 0x0737 },
    { { false, 0x91 }, 0x0E00 },
    { { false, 0x92 }, 0x0000 },
    { { false, 0x93 }, 0x3800 },
    { { false, 0xB0 }, 0xE080 },
    { { false, 0xB1 }, 0x0040 },
    { { false, 0xB4 }, 0x2206 },
    { { false, 0xB5 }, 0x1F00 },
    { { false, 0xB6 }, 0x0000 },
    { { false, 0xBB }, 0x0000 },
    { { false, 0xBD }, 0x4000 },
    { { false, 0xBE }, 0x8000 },
    { { false, 0xBF }, 0x0000 },
    { { false, 0xC0 }, 0x8400 },
    { { false, 0xC2 }, 0x0004 },
    { { false, 0xC8 }, 0x0000 },
    { { false, 0xC9 }, 0x0000 },
    { { false, 0xCA }, 0x0000 },
    { { false, 0xCB }, 0x0000 },
    { { false, 0xCC }, 0x0000 },
    { { false, 0xD3 }, 0x2A20 },
    { { false, 0xD6 }, 0x0400 },
    { { false, 0xD9 }, 0x0809 },
    { { false, 0xFA }, 0x3E01 },
    { { false, 0xFB }, 0x0000 },
    { { false, 0xFE }, 0x10EC },
    { { true, 0x12 }, 0x0AA8 },
    { { true, 0x14 }, 0x8AAA },
    { { true, 0x1B }, 0x0200 },
    { { true, 0x1D }, 0x0347 },
    { { true, 0x20 }, 0x6110 },
    { { true, 0x23 }, 0x0804 },
    { { true, 0x37 }, 0xFC00 },
    { { true, 0x3A }, 0x4002 },
    { { true, 0x3D }, 0x3600 },
    { { true, 0x6E }, 0x3019 },
    { { true, 0x77 }, 0x1F00 },
    { { true, 0x90 }, 0x2000 },
    { { true, 0x91 }, 0x1000 },
    { { true, 0xA0 }, 0x1C10 },
    { { true, 0xA1 }, 0x01F4 },
    { { true, 0xA2 }, 0xC5E9 },
    { { true, 0xA3 }, 0x1A98 },
    { { true, 0xA4 }, 0x1D2C },
    { { true, 0xA5 }, 0xC882 },
    { { true, 0xA6 }, 0x1C10 },
    { { true, 0xA7 }, 0x01F4 },
    { { true, 0xA8 }, 0xE904 },
    { { true, 0xA9 }, 0x1C10 },
    { { true, 0xAA }, 0x01F4 },
    { { true, 0xAB }, 0xE904 },
    { { true, 0xAC }, 0x1C10 },
    { { true, 0xAD }, 0x01F4 },
    { { true, 0xAE }, 0x1C10 },
    { { true, 0xAF }, 0x01F4 },
    { { true, 0xB0 }, 0x1F68 },
    { { true, 0xB1 }, 0x0094 },
    { { true, 0xB2 }, 0x1F69 },
};

// SetSpeakerMute(false) -> SetOutVolume(0) -> SetOutVolume(0xaa)
static const TestPatternForAlc5639 testPattern_03[] = {
    { { false, 0x00 }, 0x0008 },
    { { false, 0x00 }, 0x0008 },
    { { false, 0x01 }, 0x8484 },
    { { false, 0x02 }, 0x1111 },
    { { false, 0x03 }, 0xC8C8 },
    { { false, 0x0D }, 0x5000 },
    { { false, 0x0E }, 0x0000 },
    { { false, 0x0F }, 0x0808 },
    { { false, 0x19 }, 0xAAAA },
    { { false, 0x1C }, 0x1F80 },
    { { false, 0x1D }, 0x2F2F },
    { { false, 0x1E }, 0x0000 },
    { { false, 0x27 }, 0x3060 },
    { { false, 0x28 }, 0x7070 },
    { { false, 0x29 }, 0x8080 },
    { { false, 0x2A }, 0x1414 },
    { { false, 0x2B }, 0x5454 },
    { { false, 0x2C }, 0xAA00 },
    { { false, 0x2F }, 0x2000 },
    { { false, 0x3B }, 0x0000 },
    { { false, 0x3C }, 0x007F },
    { { false, 0x3D }, 0x0000 },
    { { false, 0x3E }, 0x007F },
    { { false, 0x45 }, 0xC000 },
    { { false, 0x46 }, 0x0036 },
    { { false, 0x47 }, 0x0036 },
    { { false, 0x48 }, 0xE800 },
    { { false, 0x49 }, 0x2800 },
    { { false, 0x4A }, 0x0004 },
    { { false, 0x4D }, 0x0000 },
    { { false, 0x4E }, 0x0000 },
    { { false, 0x4F }, 0x01FE },
    { { false, 0x50 }, 0x0000 },
    { { false, 0x51 }, 0x0000 },
    { { false, 0x52 }, 0x01FE },
    { { false, 0x53 }, 0xF000 },
    { { false, 0x61 }, 0x8000 },
    { { false, 0x62 }, 0x0000 },
    { { false, 0x63 }, 0xE8F8 },
    { { false, 0x64 }, 0x0000 },
    { { false, 0x65 }, 0xC000 },
    { { false, 0x66 }, 0x0C00 },
    // { { false, 0x6A }, 0x00B2 },
    // { { false, 0x6C }, 0x1F69 },
    { { false, 0x70 }, 0x8000 },
    { { false, 0x71 }, 0x8000 },
    { { false, 0x73 }, 0x8814 },
    { { false, 0x75 }, 0x1D00 },
    { { false, 0x80 }, 0x0000 },
    { { false, 0x81 }, 0x0000 },
    { { false, 0x82 }, 0x0000 },
    { { false, 0x83 }, 0x0000 },
    { { false, 0x84 }, 0x0000 },
    { { false, 0x85 }, 0x0008 },
    { { false, 0x89 }, 0x0000 },
    { { false, 0x8A }, 0x0000 },
    { { false, 0x8C }, 0x0328 },
    { { false, 0x8D }, 0xA800 },
    { { false, 0x8E }, 0x8019 },
    { { false, 0x8F }, 0x3100 },
    { { false, 0x90 }, 0x0737 },
    { { false, 0x91 }, 0x0E00 },
    { { false, 0x92 }, 0x0000 },
    { { false, 0x93 }, 0x3800 },
    { { false, 0xB0 }, 0xE080 },
    { { false, 0xB1 }, 0x0040 },
    { { false, 0xB4 }, 0x2206 },
    { { false, 0xB5 }, 0x1F00 },
    { { false, 0xB6 }, 0x0000 },
    { { false, 0xBB }, 0x0000 },
    { { false, 0xBD }, 0x4000 },
    { { false, 0xBE }, 0x8000 },
    { { false, 0xBF }, 0x0000 },
    { { false, 0xC0 }, 0x8400 },
    { { false, 0xC2 }, 0x0004 },
    { { false, 0xC8 }, 0x0000 },
    { { false, 0xC9 }, 0x0000 },
    { { false, 0xCA }, 0x0000 },
    { { false, 0xCB }, 0x0000 },
    { { false, 0xCC }, 0x0000 },
    { { false, 0xD3 }, 0x2A20 },
    { { false, 0xD6 }, 0x0400 },
    { { false, 0xD9 }, 0x0809 },
    { { false, 0xFA }, 0x3E01 },
    { { false, 0xFB }, 0x0000 },
    { { false, 0xFE }, 0x10EC },
    { { true, 0x12 }, 0x0AA8 },
    { { true, 0x14 }, 0x8AAA },
    { { true, 0x1B }, 0x0200 },
    { { true, 0x1D }, 0x0347 },
    { { true, 0x20 }, 0x6110 },
    { { true, 0x23 }, 0x0804 },
    { { true, 0x37 }, 0xFC00 },
    { { true, 0x3A }, 0x4002 },
    { { true, 0x3D }, 0x3600 },
    { { true, 0x6E }, 0x3019 },
    { { true, 0x77 }, 0x1F00 },
    { { true, 0x90 }, 0x2000 },
    { { true, 0x91 }, 0x1000 },
    { { true, 0xA0 }, 0x1C10 },
    { { true, 0xA1 }, 0x01F4 },
    { { true, 0xA2 }, 0xC5E9 },
    { { true, 0xA3 }, 0x1A98 },
    { { true, 0xA4 }, 0x1D2C },
    { { true, 0xA5 }, 0xC882 },
    { { true, 0xA6 }, 0x1C10 },
    { { true, 0xA7 }, 0x01F4 },
    { { true, 0xA8 }, 0xE904 },
    { { true, 0xA9 }, 0x1C10 },
    { { true, 0xAA }, 0x01F4 },
    { { true, 0xAB }, 0xE904 },
    { { true, 0xAC }, 0x1C10 },
    { { true, 0xAD }, 0x01F4 },
    { { true, 0xAE }, 0x1C10 },
    { { true, 0xAF }, 0x01F4 },
    { { true, 0xB0 }, 0x1F68 },
    { { true, 0xB1 }, 0x0094 },
    { { true, 0xB2 }, 0x1F69 },
};

// SetSpeakerMute(false) -> SetOutVolume(0) -> SetOutVolume(0xaa) -> SetSpeakerMute(true)
static const TestPatternForAlc5639 testPattern_04[] = {
    { { false, 0x00 }, 0x0008 },
    { { false, 0x00 }, 0x0008 },
    { { false, 0x01 }, 0x0404 },
    { { false, 0x02 }, 0x9191 },
    { { false, 0x03 }, 0xC8C8 },
    { { false, 0x0D }, 0x5000 },
    { { false, 0x0E }, 0x0000 },
    { { false, 0x0F }, 0x0808 },
    { { false, 0x19 }, 0xAAAA },
    { { false, 0x1C }, 0x1F80 },
    { { false, 0x1D }, 0x2F2F },
    { { false, 0x1E }, 0x0000 },
    { { false, 0x27 }, 0x3060 },
    { { false, 0x28 }, 0x7070 },
    { { false, 0x29 }, 0x8080 },
    { { false, 0x2A }, 0x1414 },
    { { false, 0x2B }, 0x5454 },
    { { false, 0x2C }, 0xAA00 },
    { { false, 0x2F }, 0x2000 },
    { { false, 0x3B }, 0x0000 },
    { { false, 0x3C }, 0x007F },
    { { false, 0x3D }, 0x0000 },
    { { false, 0x3E }, 0x007F },
    { { false, 0x45 }, 0xC000 },
    { { false, 0x46 }, 0x0036 },
    { { false, 0x47 }, 0x0036 },
    { { false, 0x48 }, 0xE800 },
    { { false, 0x49 }, 0x2800 },
    { { false, 0x4A }, 0x0004 },
    { { false, 0x4D }, 0x0000 },
    { { false, 0x4E }, 0x0000 },
    { { false, 0x4F }, 0x01FE },
    { { false, 0x50 }, 0x0000 },
    { { false, 0x51 }, 0x0000 },
    { { false, 0x52 }, 0x01FE },
    { { false, 0x53 }, 0xF000 },
    { { false, 0x61 }, 0x8001 },
    { { false, 0x62 }, 0x0000 },
    { { false, 0x63 }, 0xE818 },
    { { false, 0x64 }, 0x0000 },
    { { false, 0x65 }, 0x3000 },
    { { false, 0x66 }, 0xC000 },
    // { { false, 0x6A }, 0x00B4 },
    // { { false, 0x6C }, 0x0800 },
    { { false, 0x70 }, 0x8000 },
    { { false, 0x71 }, 0x8000 },
    { { false, 0x73 }, 0x8814 },
    { { false, 0x75 }, 0x1D00 },
    { { false, 0x80 }, 0x0000 },
    { { false, 0x81 }, 0x0000 },
    { { false, 0x82 }, 0x0000 },
    { { false, 0x83 }, 0x0000 },
    { { false, 0x84 }, 0x0000 },
    { { false, 0x85 }, 0x0008 },
    { { false, 0x89 }, 0x0000 },
    { { false, 0x8A }, 0x0000 },
    { { false, 0x8C }, 0x0328 },
    { { false, 0x8D }, 0xA800 },
    { { false, 0x8E }, 0x0084 },
    { { false, 0x8F }, 0x1100 },
    { { false, 0x90 }, 0x0646 },
    { { false, 0x91 }, 0x0C00 },
    { { false, 0x92 }, 0x0000 },
    { { false, 0x93 }, 0x3800 },
    { { false, 0xB0 }, 0x6000 },
    { { false, 0xB1 }, 0x00C1 },
    { { false, 0xB4 }, 0x6B30 },
    { { false, 0xB5 }, 0x1F80 },
    { { false, 0xB6 }, 0x0480 },
    { { false, 0xBB }, 0x0000 },
    { { false, 0xBD }, 0x4000 },
    { { false, 0xBE }, 0x8000 },
    { { false, 0xBF }, 0x0000 },
    { { false, 0xC0 }, 0x8400 },
    { { false, 0xC2 }, 0x0004 },
    { { false, 0xC8 }, 0x0000 },
    { { false, 0xC9 }, 0x0000 },
    { { false, 0xCA }, 0x0000 },
    { { false, 0xCB }, 0x0000 },
    { { false, 0xCC }, 0x0000 },
    { { false, 0xD3 }, 0x2A20 },
    { { false, 0xD6 }, 0x0400 },
    { { false, 0xD9 }, 0x0809 },
    { { false, 0xFA }, 0x3E01 },
    { { false, 0xFB }, 0x0000 },
    { { false, 0xFE }, 0x10EC },
    { { true, 0x12 }, 0x0AA8 },
    { { true, 0x14 }, 0x8AAA },
    { { true, 0x1B }, 0x0200 },
    { { true, 0x1D }, 0x0347 },
    { { true, 0x20 }, 0x6110 },
    { { true, 0x23 }, 0x0804 },
    { { true, 0x37 }, 0xFC00 },
    { { true, 0x3A }, 0x4002 },
    { { true, 0x3D }, 0x3600 },
    { { true, 0x6E }, 0x3019 },
    { { true, 0x77 }, 0x1F00 },
    { { true, 0x90 }, 0x2000 },
    { { true, 0x91 }, 0x1000 },
    { { true, 0xA0 }, 0xED87 },
    { { true, 0xA1 }, 0x0000 },
    { { true, 0xA2 }, 0xC5E9 },
    { { true, 0xA3 }, 0x1A98 },
    { { true, 0xA4 }, 0x1D2C },
    { { true, 0xA5 }, 0xC882 },
    { { true, 0xA6 }, 0x1C10 },
    { { true, 0xA7 }, 0x01F4 },
    { { true, 0xA8 }, 0xE904 },
    { { true, 0xA9 }, 0x1C10 },
    { { true, 0xAA }, 0x01F4 },
    { { true, 0xAB }, 0xE904 },
    { { true, 0xAC }, 0x1C10 },
    { { true, 0xAD }, 0x01F4 },
    { { true, 0xAE }, 0x1C10 },
    { { true, 0xAF }, 0x01F4 },
    { { true, 0xB0 }, 0x1FB4 },
    { { true, 0xB1 }, 0x004B },
    { { true, 0xB2 }, 0x1FB4 },
};

// SetSpeakerMute(false) -> SetOutVolume(0) -> SetOutVolume(0xaa) -> SetSpeakerMute(true) -> SetOutVolume(0)
static const TestPatternForAlc5639 testPattern_05[] = {
    { { false, 0x00 }, 0x0008 },
    { { false, 0x00 }, 0x0008 },
    { { false, 0x01 }, 0x8484 },
    { { false, 0x02 }, 0x9191 },
    { { false, 0x03 }, 0xC8C8 },
    { { false, 0x0D }, 0x5000 },
    { { false, 0x0E }, 0x0000 },
    { { false, 0x0F }, 0x0808 },
    { { false, 0x19 }, 0x0000 },
    { { false, 0x1C }, 0x1F80 },
    { { false, 0x1D }, 0x2F2F },
    { { false, 0x1E }, 0x0000 },
    { { false, 0x27 }, 0x3060 },
    { { false, 0x28 }, 0x7070 },
    { { false, 0x29 }, 0x8080 },
    { { false, 0x2A }, 0x1414 },
    { { false, 0x2B }, 0x5454 },
    { { false, 0x2C }, 0xAA00 },
    { { false, 0x2F }, 0x2000 },
    { { false, 0x3B }, 0x0000 },
    { { false, 0x3C }, 0x007F },
    { { false, 0x3D }, 0x0000 },
    { { false, 0x3E }, 0x007F },
    { { false, 0x45 }, 0xC000 },
    { { false, 0x46 }, 0x0036 },
    { { false, 0x47 }, 0x0036 },
    { { false, 0x48 }, 0xE800 },
    { { false, 0x49 }, 0x2800 },
    { { false, 0x4A }, 0x0004 },
    { { false, 0x4D }, 0x0000 },
    { { false, 0x4E }, 0x0000 },
    { { false, 0x4F }, 0x01FE },
    { { false, 0x50 }, 0x0000 },
    { { false, 0x51 }, 0x0000 },
    { { false, 0x52 }, 0x01FE },
    { { false, 0x53 }, 0xF000 },
    { { false, 0x61 }, 0x8001 },
    { { false, 0x62 }, 0x0000 },
    { { false, 0x63 }, 0xE818 },
    { { false, 0x64 }, 0x0000 },
    { { false, 0x65 }, 0x3000 },
    { { false, 0x66 }, 0xC000 },
    // { { false, 0x6A }, 0x00B2 },
    // { { false, 0x6C }, 0x1FB4 },
    { { false, 0x70 }, 0x8000 },
    { { false, 0x71 }, 0x8000 },
    { { false, 0x73 }, 0x8814 },
    { { false, 0x75 }, 0x1D00 },
    { { false, 0x80 }, 0x0000 },
    { { false, 0x81 }, 0x0000 },
    { { false, 0x82 }, 0x0000 },
    { { false, 0x83 }, 0x0000 },
    { { false, 0x84 }, 0x0000 },
    { { false, 0x85 }, 0x0008 },
    { { false, 0x89 }, 0x0000 },
    { { false, 0x8A }, 0x0000 },
    { { false, 0x8C }, 0x0328 },
    { { false, 0x8D }, 0xA800 },
    { { false, 0x8E }, 0x0084 },
    { { false, 0x8F }, 0x1100 },
    { { false, 0x90 }, 0x0646 },
    { { false, 0x91 }, 0x0C00 },
    { { false, 0x92 }, 0x0000 },
    { { false, 0x93 }, 0x3800 },
    { { false, 0xB0 }, 0x6080 },
    { { false, 0xB1 }, 0x00C1 },
    { { false, 0xB4 }, 0x6B30 },
    { { false, 0xB5 }, 0x1F80 },
    { { false, 0xB6 }, 0x0480 },
    { { false, 0xBB }, 0x0000 },
    { { false, 0xBD }, 0x4000 },
    { { false, 0xBE }, 0x8000 },
    { { false, 0xBF }, 0x0000 },
    { { false, 0xC0 }, 0x8400 },
    { { false, 0xC2 }, 0x0004 },
    { { false, 0xC8 }, 0x0000 },
    { { false, 0xC9 }, 0x0000 },
    { { false, 0xCA }, 0x0000 },
    { { false, 0xCB }, 0x0000 },
    { { false, 0xCC }, 0x0000 },
    { { false, 0xD3 }, 0x2A20 },
    { { false, 0xD6 }, 0x0400 },
    { { false, 0xD9 }, 0x0809 },
    { { false, 0xFA }, 0x3E01 },
    { { false, 0xFB }, 0x0000 },
    { { false, 0xFE }, 0x10EC },
    { { true, 0x12 }, 0x0AA8 },
    { { true, 0x14 }, 0x8AAA },
    { { true, 0x1B }, 0x0200 },
    { { true, 0x1D }, 0x0347 },
    { { true, 0x20 }, 0x6110 },
    { { true, 0x23 }, 0x0804 },
    { { true, 0x37 }, 0xFC00 },
    { { true, 0x3A }, 0x4002 },
    { { true, 0x3D }, 0x3600 },
    { { true, 0x6E }, 0x3019 },
    { { true, 0x77 }, 0x1F00 },
    { { true, 0x90 }, 0x2000 },
    { { true, 0x91 }, 0x1000 },
    { { true, 0xA0 }, 0xED87 },
    { { true, 0xA1 }, 0x0000 },
    { { true, 0xA2 }, 0xC5E9 },
    { { true, 0xA3 }, 0x1A98 },
    { { true, 0xA4 }, 0x1D2C },
    { { true, 0xA5 }, 0xC882 },
    { { true, 0xA6 }, 0x1C10 },
    { { true, 0xA7 }, 0x01F4 },
    { { true, 0xA8 }, 0xE904 },
    { { true, 0xA9 }, 0x1C10 },
    { { true, 0xAA }, 0x01F4 },
    { { true, 0xAB }, 0xE904 },
    { { true, 0xAC }, 0x1C10 },
    { { true, 0xAD }, 0x01F4 },
    { { true, 0xAE }, 0x1C10 },
    { { true, 0xAF }, 0x01F4 },
    { { true, 0xB0 }, 0x1FB4 },
    { { true, 0xB1 }, 0x004B },
    { { true, 0xB2 }, 0x1FB4 },
};

// SetSpeakerMute(false) -> SetOutVolume(0) -> SetOutVolume(0xaa) -> SetSpeakerMute(true) -> SetOutVolume(0x94) -> SetOutVolume(0x94)
static const TestPatternForAlc5639 testPattern_06[] = {
    { { false, 0x00 }, 0x0008 },
    { { false, 0x00 }, 0x0008 },
    { { false, 0x01 }, 0x0404 },
    { { false, 0x02 }, 0x9191 },
    { { false, 0x03 }, 0xC8C8 },
    { { false, 0x0D }, 0x5000 },
    { { false, 0x0E }, 0x0000 },
    { { false, 0x0F }, 0x0808 },
    { { false, 0x19 }, 0x9494 },
    { { false, 0x1C }, 0x1F80 },
    { { false, 0x1D }, 0x2F2F },
    { { false, 0x1E }, 0x0000 },
    { { false, 0x27 }, 0x3060 },
    { { false, 0x28 }, 0x7070 },
    { { false, 0x29 }, 0x8080 },
    { { false, 0x2A }, 0x1414 },
    { { false, 0x2B }, 0x5454 },
    { { false, 0x2C }, 0xAA00 },
    { { false, 0x2F }, 0x2000 },
    { { false, 0x3B }, 0x0000 },
    { { false, 0x3C }, 0x007F },
    { { false, 0x3D }, 0x0000 },
    { { false, 0x3E }, 0x007F },
    { { false, 0x45 }, 0xC000 },
    { { false, 0x46 }, 0x0036 },
    { { false, 0x47 }, 0x0036 },
    { { false, 0x48 }, 0xE800 },
    { { false, 0x49 }, 0x2800 },
    { { false, 0x4A }, 0x0004 },
    { { false, 0x4D }, 0x0000 },
    { { false, 0x4E }, 0x0000 },
    { { false, 0x4F }, 0x01FE },
    { { false, 0x50 }, 0x0000 },
    { { false, 0x51 }, 0x0000 },
    { { false, 0x52 }, 0x01FE },
    { { false, 0x53 }, 0xF000 },
    { { false, 0x61 }, 0x8001 },
    { { false, 0x62 }, 0x0000 },
    { { false, 0x63 }, 0xE818 },
    { { false, 0x64 }, 0x0000 },
    { { false, 0x65 }, 0x3000 },
    { { false, 0x66 }, 0xC000 },
    // { { false, 0x6A }, 0x00B2 },
    // { { false, 0x6C }, 0x1FB4 },
    { { false, 0x70 }, 0x8000 },
    { { false, 0x71 }, 0x8000 },
    { { false, 0x73 }, 0x8814 },
    { { false, 0x75 }, 0x1D00 },
    { { false, 0x80 }, 0x0000 },
    { { false, 0x81 }, 0x0000 },
    { { false, 0x82 }, 0x0000 },
    { { false, 0x83 }, 0x0000 },
    { { false, 0x84 }, 0x0000 },
    { { false, 0x85 }, 0x0008 },
    { { false, 0x89 }, 0x0000 },
    { { false, 0x8A }, 0x0000 },
    { { false, 0x8C }, 0x0328 },
    { { false, 0x8D }, 0xA800 },
    { { false, 0x8E }, 0x0084 },
    { { false, 0x8F }, 0x1100 },
    { { false, 0x90 }, 0x0646 },
    { { false, 0x91 }, 0x0C00 },
    { { false, 0x92 }, 0x0000 },
    { { false, 0x93 }, 0x3800 },
    { { false, 0xB0 }, 0x6080 },
    { { false, 0xB1 }, 0x00C1 },
    { { false, 0xB4 }, 0x6B30 },
    { { false, 0xB5 }, 0x1F80 },
    { { false, 0xB6 }, 0x0480 },
    { { false, 0xBB }, 0x0000 },
    { { false, 0xBD }, 0x4000 },
    { { false, 0xBE }, 0x8000 },
    { { false, 0xBF }, 0x0000 },
    { { false, 0xC0 }, 0x8400 },
    { { false, 0xC2 }, 0x0004 },
    { { false, 0xC8 }, 0x0000 },
    { { false, 0xC9 }, 0x0000 },
    { { false, 0xCA }, 0x0000 },
    { { false, 0xCB }, 0x0000 },
    { { false, 0xCC }, 0x0000 },
    { { false, 0xD3 }, 0x2A20 },
    { { false, 0xD6 }, 0x0400 },
    { { false, 0xD9 }, 0x0809 },
    { { false, 0xFA }, 0x3E01 },
    { { false, 0xFB }, 0x0000 },
    { { false, 0xFE }, 0x10EC },
    { { true, 0x12 }, 0x0AA8 },
    { { true, 0x14 }, 0x8AAA },
    { { true, 0x1B }, 0x0200 },
    { { true, 0x1D }, 0x0347 },
    { { true, 0x20 }, 0x6110 },
    { { true, 0x23 }, 0x0804 },
    { { true, 0x37 }, 0xFC00 },
    { { true, 0x3A }, 0x4002 },
    { { true, 0x3D }, 0x3600 },
    { { true, 0x6E }, 0x3019 },
    { { true, 0x77 }, 0x1F00 },
    { { true, 0x90 }, 0x2000 },
    { { true, 0x91 }, 0x1000 },
    { { true, 0xA0 }, 0xED87 },
    { { true, 0xA1 }, 0x0000 },
    { { true, 0xA2 }, 0xC5E9 },
    { { true, 0xA3 }, 0x1A98 },
    { { true, 0xA4 }, 0x1D2C },
    { { true, 0xA5 }, 0xC882 },
    { { true, 0xA6 }, 0x1C10 },
    { { true, 0xA7 }, 0x01F4 },
    { { true, 0xA8 }, 0xE904 },
    { { true, 0xA9 }, 0x1C10 },
    { { true, 0xAA }, 0x01F4 },
    { { true, 0xAB }, 0xE904 },
    { { true, 0xAC }, 0x1C10 },
    { { true, 0xAD }, 0x01F4 },
    { { true, 0xAE }, 0x1C10 },
    { { true, 0xAF }, 0x01F4 },
    { { true, 0xB0 }, 0x1FB4 },
    { { true, 0xB1 }, 0x004B },
    { { true, 0xB2 }, 0x1FB4 },
};

static const RegisterForAlc5639 RegistersListForAlc5639[] = {
    // Public Regs
    { false, 0x00 },
    { false, 0x00 },
    { false, 0x01 },
    { false, 0x02 },
    { false, 0x03 },
    { false, 0x0D },
    { false, 0x0E },
    { false, 0x0F },
    { false, 0x19 },
    { false, 0x1C },
    { false, 0x1D },
    { false, 0x1E },
    { false, 0x27 },
    { false, 0x28 },
    { false, 0x29 },
    { false, 0x2A },
    { false, 0x2B },
    { false, 0x2C },
    { false, 0x2F },
    { false, 0x3B },
    { false, 0x3C },
    { false, 0x3D },
    { false, 0x3E },
    { false, 0x45 },
    { false, 0x46 },
    { false, 0x47 },
    { false, 0x48 },
    { false, 0x49 },
    { false, 0x4A },
    { false, 0x4D },
    { false, 0x4E },
    { false, 0x4F },
    { false, 0x50 },
    { false, 0x51 },
    { false, 0x52 },
    { false, 0x53 },
    { false, 0x61 },
    { false, 0x62 },
    { false, 0x63 },
    { false, 0x64 },
    { false, 0x65 },
    { false, 0x66 },
    { false, 0x6A },
    { false, 0x6C },
    { false, 0x70 },
    { false, 0x71 },
    { false, 0x73 },
    { false, 0x75 },
    { false, 0x80 },
    { false, 0x81 },
    { false, 0x82 },
    { false, 0x83 },
    { false, 0x84 },
    { false, 0x85 },
    { false, 0x89 },
    { false, 0x8A },
    { false, 0x8C },
    { false, 0x8D },
    { false, 0x8E },
    { false, 0x8F },
    { false, 0x90 },
    { false, 0x91 },
    { false, 0x92 },
    { false, 0x93 },
    { false, 0xB0 },
    { false, 0xB1 },
    { false, 0xB4 },
    { false, 0xB5 },
    { false, 0xB6 },
    { false, 0xBB },
    { false, 0xBD },
    { false, 0xBE },
    { false, 0xBF },
    { false, 0xC0 },
    { false, 0xC2 },
    { false, 0xC8 },
    { false, 0xC9 },
    { false, 0xCA },
    { false, 0xCB },
    { false, 0xCC },
    { false, 0xD3 },
    { false, 0xD6 },
    { false, 0xD9 },
    { false, 0xFA },
    { false, 0xFB },
    { false, 0xFE },

    // Private Regs
    { true, 0x12 },
    { true, 0x14 },
    { true, 0x1B },
    { true, 0x1D },
    { true, 0x20 },
    { true, 0x23 },
    { true, 0x37 },
    { true, 0x3A },
    { true, 0x3D },
    { true, 0x6E },
    { true, 0x77 },
    { true, 0x90 },
    { true, 0x91 },
    { true, 0xA0 },
    { true, 0xA1 },
    { true, 0xA2 },
    { true, 0xA3 },
    { true, 0xA4 },
    { true, 0xA5 },
    { true, 0xA6 },
    { true, 0xA7 },
    { true, 0xA8 },
    { true, 0xA9 },
    { true, 0xAA },
    { true, 0xAB },
    { true, 0xAC },
    { true, 0xAD },
    { true, 0xAE },
    { true, 0xAF },
    { true, 0xB0 },
    { true, 0xB1 },
    { true, 0xB2 },
};
