﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "testAtk_TestEffectUtil.h"

#include <nnt.h>
#include <nn/atk.h>
#include <nnt/atkUtil/testAtk_Util.h>

namespace nnt { namespace atk { namespace effectUtil {

bool EffectAuxTest::Initialize() NN_NOEXCEPT
{
    NN_LOG("EffectAuxTest: Initialize().\n");
    return true;
}
void EffectAuxTest::Finalize() NN_NOEXCEPT
{
    NN_LOG("EffectAuxTest: Finalize().\n");
}
void EffectAuxTest::UpdateSamples(int32_t* pSamples, const UpdateSamplesArg& arg) NN_NOEXCEPT
{
    NN_UNUSED(pSamples);
    NN_UNUSED(arg);
}

void UpdateAndProcess(nn::atk::SoundArchivePlayer& soundArchivePlayer) NN_NOEXCEPT
{
    soundArchivePlayer.Update();
#if defined(NNT_ATK_ENABLE_VOICE_COMMAND)
    nn::atk::SoundSystem::VoiceCommandProcess(4);
#endif
}

template <class Effect> void WaitForChangeEffectRemovability(Effect& effect, bool isRemovable) NN_NOEXCEPT
{
    for (auto elapsed = nn::TimeSpan::FromMilliSeconds(0); elapsed < TimeOut; elapsed += WaitTime)
    {
        nn::os::SleepThread(WaitTime);
        if (effect.IsRemovable() == isRemovable) break;
    }
    EXPECT_EQ(effect.IsRemovable(), isRemovable) << "Change effect removability is timed out.";
}

void WaitForEffectClear(nn::atk::EffectBase& effect) NN_NOEXCEPT
{
    WaitForChangeEffectRemovability( effect, true );
}

void WaitForEffectClear(nn::atk::EffectAux& effect) NN_NOEXCEPT
{
    WaitForChangeEffectRemovability( effect, true );
}

void WaitForEffectAppend(nn::atk::EffectBase& effect) NN_NOEXCEPT
{
    WaitForChangeEffectRemovability( effect, false );
}

void WaitForEffectAppend(nn::atk::EffectAux& effect) NN_NOEXCEPT
{
    WaitForChangeEffectRemovability( effect, false );
}

int ConvertChannelModeToInt(nn::atk::EffectBase::ChannelMode channelMode) NN_NOEXCEPT
{
    switch (channelMode)
    {
    case nn::atk::EffectBase::ChannelMode_1Ch:
        return 1;
    case nn::atk::EffectBase::ChannelMode_2Ch:
        return 2;
    case nn::atk::EffectBase::ChannelMode_4Ch:
        return 4;
    case nn::atk::EffectBase::ChannelMode_6Ch:
        return 6;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

int ConvertSampleRateToInt(nn::atk::EffectBase::SampleRate sampleRate) NN_NOEXCEPT
{
    switch (sampleRate)
    {
    case nn::atk::EffectBase::SampleRate_32000:
        return 32000;
    case nn::atk::EffectBase::SampleRate_48000:
        return 48000;
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

void AppendEffectAndWait(nn::atk::AuxBus bus, nn::atk::EffectBase* pEffect, void* buffer, size_t bufferSize, nn::atk::SoundArchivePlayer& soundArchivePlayer) NN_NOEXCEPT
{
    NN_UNUSED(soundArchivePlayer);
    nn::atk::SoundSystem::AppendEffect(bus, pEffect, buffer, bufferSize);
    nnt::atk::util::WaitForProcessCommand();
}

void RemoveEffectAndWait(nn::atk::AuxBus bus, nn::atk::EffectBase* pEffect, nn::atk::SoundArchivePlayer& soundArchivePlayer) NN_NOEXCEPT
{
    // RemoveEffect は中で WaitCommandReply を呼んでいるので、待つ必要はない
    NN_UNUSED(soundArchivePlayer);
    nn::atk::SoundSystem::RemoveEffect(bus, pEffect);
}

}}}
