﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "testAtk_TestHeap.h"

//------------------------------------------------------------------------------
//! @brief  ファイルの読み書きを行うクラスです。
//------------------------------------------------------------------------------
class FileManager
{
public:
    //---------------------------------------------------------------------------
    //! @brief  ヒープを設定します。
    //!
    //! @param[in] pHeap ヒープ
    //---------------------------------------------------------------------------
    void SetHeap( TestHeap* pHeap );

    //!------------------------------------------------------------------------------
    //! @brief  データをファイルから読み込みます。
    //!
    //! @param[in]  pPath  ファイルパス
    //! @param[out] ppData データ
    //! @param[out] pSize  データサイズ
    //! @return 読み込んだデータを返します。
    //!         このデータが不要になったときはReleaseData関数を使用してデータを破棄してください。
    //!------------------------------------------------------------------------------
    bool ReadFile ( const char* pPath, char** ppData, size_t* pSize );

    //!------------------------------------------------------------------------------
    //! @brief  ファイルから読み込んだデータを破棄します。
    //!
    //! @return pData データ
    //!------------------------------------------------------------------------------
    void ReleaseData ( char* pData );

    //!------------------------------------------------------------------------------
    //! @brief  データをファイルに保存します。
    //!
    //! @param[in] pData データ
    //! @param[in] size  データサイズ
    //! @param[in] pPath ファイルパス
    //!------------------------------------------------------------------------------
    bool WriteFile( const char* pData, size_t size, const char* pPath );

private:
    TestHeap* m_pHeap;  //! ヒープ
};
