﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// ロジックを実装するクラス nn::sfsmpl_impl::SfSampleManagerImpl の実装

#include <cstdint>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include "testSf_AddParameter.h"
#include "testSf_Structs.h"
#include "testSf_IAllFunctionTests.sfdl.h"
#include <nn/sf/impl/sf_ExpHeapAllocator.h>
#include <atomic>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/result/result_ErrorResult.h>

namespace nnt { namespace testsf {

class AllFunctionTestsImpl
    : public nn::sf::ISharedObject
{
private:

    nn::sf::impl::ExpHeapAllocator* m_Allocator;
    int m_IntValue;
    std::atomic_int m_SessionCount;
    nn::sf::NativeHandle m_NativeHandle;
    nn::Bit64 m_ClientProcessId;
    bool m_ReturnedInvalidContext;

    class SessionImpl;

public:

    // コンストラクタは任意の引数を取ってよい。
    // この引数は、Create～ 関数の引数に引き継がれる。
    NN_IMPLICIT AllFunctionTestsImpl(nn::sf::impl::ExpHeapAllocator* allocator, int x) NN_NOEXCEPT;

    // 実装するべきメンバ関数は、自動生成された sfsmpl_SfSampleManagerImplTemplate.impl.h に出力されている。
    int EchoInt(int x) NN_NOEXCEPT;
    nn::Result StoreIntWithResult(int x) NN_NOEXCEPT;
    void StoreInt(int x) NN_NOEXCEPT;
    int LoadInt() NN_NOEXCEPT;
    void FlipBits(const nn::sf::OutBuffer& outBuffer, const nn::sf::InBuffer& inBuffer) NN_NOEXCEPT;
    std::int32_t Add(nnt::testsf::AddParameter p) NN_NOEXCEPT;
    std::int32_t SumAndSubBytes(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
    std::int32_t SumAndSubBytes2(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
    std::int32_t SumAndSubBytes3(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
    std::int32_t SumAndSubBytes4(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
    void LoadIntByOut(nn::sf::Out<int> pOut) NN_NOEXCEPT;
    nnt::testsf::Struct2 EchoStruct(const nnt::testsf::Struct1& s) NN_NOEXCEPT;
    void EchoStruct2(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT;
    nn::sf::SharedPointer<nnt::testsf::ITestSession> OpenSession(int value) NN_NOEXCEPT;
    void OpenSession2(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::ITestSession>> pOut, int value) NN_NOEXCEPT;
    void OpenSessionChar(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::ITestSession>> pOut, nn::sf::Out<char> pCharOut, char x) NN_NOEXCEPT;
    int GetSessionCount() NN_NOEXCEPT;
    nn::sf::NativeHandle GetNativeHandle() NN_NOEXCEPT;
    void GetNativeHandle2(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
    void MoveNativeHandle(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
    void InNativeHandle(nn::sf::NativeHandle&& e) NN_NOEXCEPT;
    void MoveInNativeHandle(nn::sf::NativeHandle&& e) NN_NOEXCEPT;
    void SetClientProcessId(nn::Bit64 pid) NN_NOEXCEPT;
    void GetClientProcessId(nn::sf::Out<nn::Bit64> pOut) NN_NOEXCEPT;
    void SquareArrayElement(const nn::sf::OutArray<std::int32_t>& dst, const nn::sf::InArray<std::int32_t>& src) NN_NOEXCEPT;
    void SquareArrayElement2(const nn::sf::OutArray<std::int32_t>& dst, const nn::sf::InArray<std::int32_t>& src) NN_NOEXCEPT;
    void EchoStruct3(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT;
    void EchoStruct4(nn::sf::Out<nnt::testsf::Struct2> pOut, const nnt::testsf::Struct1& s) NN_NOEXCEPT;
    void MoveNativeHandle2(nn::sf::Out<nn::sf::NativeHandle> pOut) NN_NOEXCEPT;
    bool EchoBool(bool x) NN_NOEXCEPT;
    std::uint16_t EchoUInt16(std::uint16_t x) NN_NOEXCEPT;
    std::uint64_t EchoUInt64(std::uint64_t x) NN_NOEXCEPT;
    nn::Result DeferProcess() NN_NOEXCEPT;
    nn::sf::SharedPointer<nnt::testsf::IAllFunctionTests> GetNullObject() NN_NOEXCEPT;
    void GetNullObject2(nn::sf::Out<nn::sf::SharedPointer<nnt::testsf::IAllFunctionTests>> pOut) NN_NOEXCEPT;
    nn::Result CauseError(const nn::sf::OutBuffer& outSum, const nn::sf::OutBuffer& outSub, const nn::sf::InBuffer& inBuffer1, const nn::sf::InBuffer& inBuffer2) NN_NOEXCEPT;
    nn::Result CheckAruid(nn::Bit64 aruid) NN_NOEXCEPT;
    nn::Result CheckAruid2(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
    std::uint32_t GetInlineContextTest() NN_NOEXCEPT;
    std::uint8_t GetFsInlineContextTest() NN_NOEXCEPT;

    int EchoIntInherited(int x) NN_NOEXCEPT;

    // for Test
    void SetNativeHandleForTest(nn::sf::NativeHandle&& handle) NN_NOEXCEPT;

};

nn::sf::SharedPointer<IAllFunctionTests> CreateAllFunctionTests(int n) NN_NOEXCEPT;

NN_DEFINE_ERROR_RANGE_RESULT(ResultSfTestError, 511, 100, 101);

}}
