﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/settings/system/settings_TimeZone.h>
#include <nnt/nntest.h>
#include <nn/util/util_Uuid.h>

namespace
{
::nn::time::LocationName g_LocationName;
::nn::time::SteadyClockTimePoint g_LocationUpdatedTime;
}

//!< デバイスの地域名（タイムゾーン名）を取得可能か
TEST(TimeZoneSuite, DeviceLocationNameTest1)
{
    ::nn::settings::system::GetDeviceTimeZoneLocationName(&g_LocationName);
}

//!< デバイスの地域名（タイムゾーン名）を設定可能か
TEST(TimeZoneSuite, DeviceLocationNameTest2)
{
    const ::nn::time::LocationName locationNameA = {"Asia/Tokyo"};
    ::nn::settings::system::SetDeviceTimeZoneLocationName(locationNameA);
    {
        ::nn::time::LocationName locationName;
        ::nn::settings::system::GetDeviceTimeZoneLocationName(&locationName);
        EXPECT_EQ(locationNameA, locationName);
    }

    const ::nn::time::LocationName locationNameB = {"Europe/London"};
    ::nn::settings::system::SetDeviceTimeZoneLocationName(locationNameB);
    {
        ::nn::time::LocationName locationName;
        ::nn::settings::system::GetDeviceTimeZoneLocationName(&locationName);
        EXPECT_EQ(locationNameB, locationName);
    }

    // 念のため元に戻す
    ::nn::settings::system::SetDeviceTimeZoneLocationName(g_LocationName);
    {
        ::nn::time::LocationName locationName;
        ::nn::settings::system::GetDeviceTimeZoneLocationName(&locationName);
        EXPECT_EQ(g_LocationName, locationName);
    }
}

//!< デバイス地域の更新時間を取得可能か
TEST(TimeZoneSuite, DeviceLocationUpdatedTime1)
{
    ::nn::settings::system::GetDeviceTimeZoneLocationUpdatedTime(&g_LocationUpdatedTime);
}

//!< デバイス地域の更新時間を設定可能か
TEST(TimeZoneSuite, DeviceLocationUpdatedTime2)
{
    ::nn::time::SteadyClockTimePoint value =
    {
        123456LL,
        ::nn::util::GenerateUuid()
    };

    ::nn::settings::system::SetDeviceTimeZoneLocationUpdatedTime(value);
    {
        ::nn::time::SteadyClockTimePoint tp;
        ::nn::settings::system::GetDeviceTimeZoneLocationUpdatedTime(&tp);
        EXPECT_EQ(value, tp);
    }

    // 念のため元に戻す
    ::nn::settings::system::SetDeviceTimeZoneLocationUpdatedTime(g_LocationUpdatedTime);
    {
        ::nn::time::SteadyClockTimePoint tp;
        ::nn::settings::system::GetDeviceTimeZoneLocationUpdatedTime(&tp);
        EXPECT_EQ(g_LocationUpdatedTime, tp);
    }
}
