﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/settings/system/settings_Sleep.h>
#include <nnt/nntest.h>

namespace {

//!< テスト用スリープ設定 A
const ::nn::settings::system::SleepSettings SleepSettingsA = {
    { { 0x00000000 } },
    static_cast<int32_t>(::nn::settings::system::HandheldSleepPlan_5Min),
    static_cast<int32_t>(::nn::settings::system::ConsoleSleepPlan_2Hour),
};

//!< テスト用スリープ設定 B
const ::nn::settings::system::SleepSettings SleepSettingsB = {
    { { 0x00000001 } },
    static_cast<int32_t>(::nn::settings::system::HandheldSleepPlan_30Min),
    static_cast<int32_t>(::nn::settings::system::ConsoleSleepPlan_12Hour),
};

} // namespace

//!< スリープ設定を取得可能か
TEST(SleepSuite, SleepSettingsTest1)
{
    ::nn::settings::system::SleepSettings settings = {};

    ::nn::settings::system::GetSleepSettings(&settings);
}

//!< スリープ設定を設定可能か
TEST(SleepSuite, SleepSettingsTest2)
{
    ::nn::settings::system::SetSleepSettings(SleepSettingsA);

    ::nn::settings::system::SleepSettings settings = {};

    ::nn::settings::system::SetSleepSettings(SleepSettingsB);

    ::nn::settings::system::GetSleepSettings(&settings);

    EXPECT_EQ(SleepSettingsB.flags, settings.flags);

    EXPECT_EQ(SleepSettingsB.handheldSleepPlan, settings.handheldSleepPlan);

    EXPECT_EQ(SleepSettingsB.consoleSleepPlan, settings.consoleSleepPlan);

    ::nn::settings::system::SetSleepSettings(SleepSettingsA);

    ::nn::settings::system::GetSleepSettings(&settings);

    EXPECT_EQ(SleepSettingsA.flags, settings.flags);

    EXPECT_EQ(SleepSettingsA.handheldSleepPlan, settings.handheldSleepPlan);

    EXPECT_EQ(SleepSettingsA.consoleSleepPlan, settings.consoleSleepPlan);
}
