﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/settings/system/settings_DataDeletion.h>
#include <nnt/nntest.h>

namespace {

//!< テスト用おすすめ削除設定 A
const ::nn::settings::system::DataDeletionSettings DataDeletionSettingsA = {
    { { 0 } },
    static_cast<int32_t>(0x5A)
};

//!< テスト用おすすめ削除設定 B
const ::nn::settings::system::DataDeletionSettings DataDeletionSettingsB = {
    { { 1 } },
    static_cast<int32_t>(0x2E)
};

} // namespace

//!< おすすめ削除設定を取得可能か
TEST(DataDeletionSuite, DataDeletionSettingsTest1)
{
    ::nn::settings::system::DataDeletionSettings settings = {};

    ::nn::settings::system::GetDataDeletionSettings(&settings);
}

//!< おすすめ削除設定を設定可能か
TEST(DataDeletionSuite, DataDeletionSettingsTest2)
{
    ::nn::settings::system::DataDeletionSettings settings = {};

    ::nn::settings::system::SetDataDeletionSettings(DataDeletionSettingsB);

    ::nn::settings::system::GetDataDeletionSettings(&settings);

    EXPECT_EQ(
        DataDeletionSettingsB.flags.Test<
            ::nn::settings::system::DataDeletionFlag::Automatic>(),
        settings.flags.Test<
            ::nn::settings::system::DataDeletionFlag::Automatic>());

    EXPECT_EQ(DataDeletionSettingsB.useCount, settings.useCount);

    ::nn::settings::system::SetDataDeletionSettings(DataDeletionSettingsA);

    ::nn::settings::system::GetDataDeletionSettings(&settings);

    EXPECT_EQ(
        DataDeletionSettingsA.flags.Test<
            ::nn::settings::system::DataDeletionFlag::Automatic>(),
        settings.flags.Test<
            ::nn::settings::system::DataDeletionFlag::Automatic>());

    EXPECT_EQ(DataDeletionSettingsA.useCount, settings.useCount);
}
