﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/settings/system/settings_Account.h>
#include <nnt/nntest.h>

namespace {

//!< テスト用アカウント設定 A
const ::nn::settings::system::AccountSettings AccountSettingsA = {
    { { { 0 } } }
};

//!< テスト用アカウント設定 B
const ::nn::settings::system::AccountSettings AccountSettingsB = {
    { { { 1 } } }
};

} // namespace

//!< アカウント設定を取得可能か
TEST(AccountSuite, AccountSettingsTest1)
{
    ::nn::settings::system::AccountSettings settings = {};

    ::nn::settings::system::GetAccountSettings(&settings);
}

//!< アカウント設定を設定可能か
TEST(AccountSuite, AccountSettingsTest2)
{
    ::nn::settings::system::SetAccountSettings(AccountSettingsA);

    ::nn::settings::system::SetAccountSettings(AccountSettingsB);

    ::nn::settings::system::AccountSettings settings = {};

    ::nn::settings::system::GetAccountSettings(&settings);

    EXPECT_EQ(
        AccountSettingsB.userSelectorSettings.flags.Test<
            ::nn::settings::system::UserSelectorFlag::SkipsIfSingleUser>(),
        settings.userSelectorSettings.flags.Test<
            ::nn::settings::system::UserSelectorFlag::SkipsIfSingleUser>());
}
