﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/settings/settings_Keyboard.h>
#include <nn/settings/system/settings_Keyboard.h>
#include <nnt/nntest.h>

//!< アプリケーション側で保持するキーボード配列の種別を変更可能か
TEST(KeyboardSuite, ApplicationOwnKeyboardLayoutTest1)
{
    auto value = ::nn::settings::KeyboardLayout();

    EXPECT_FALSE(
        ::nn::settings::system::GetApplicationOwnKeyboardLayout(&value));

    ::nn::settings::SetApplicationOwnKeyboardLayout(
        ::nn::settings::KeyboardLayout_Russian);

    value = ::nn::settings::KeyboardLayout();

    EXPECT_TRUE(
        ::nn::settings::system::GetApplicationOwnKeyboardLayout(&value));

    EXPECT_EQ(::nn::settings::KeyboardLayout_Russian, value);

    ::nn::settings::SetApplicationOwnKeyboardLayout(
        ::nn::settings::KeyboardLayout_Japanese);

    value = ::nn::settings::KeyboardLayout();

    EXPECT_TRUE(
        ::nn::settings::system::GetApplicationOwnKeyboardLayout(&value));

    EXPECT_EQ(::nn::settings::KeyboardLayout_Japanese, value);

    ::nn::settings::SetApplicationOwnKeyboardLayout(
        ::nn::settings::KeyboardLayout_Korean);

    value = ::nn::settings::KeyboardLayout();

    EXPECT_TRUE(
        ::nn::settings::system::GetApplicationOwnKeyboardLayout(&value));

    EXPECT_EQ(::nn::settings::KeyboardLayout_Korean, value);

    ::nn::settings::SetApplicationOwnKeyboardLayout(
        ::nn::settings::KeyboardLayout_ChineseSimplified);

    value = ::nn::settings::KeyboardLayout();

    EXPECT_TRUE(
        ::nn::settings::system::GetApplicationOwnKeyboardLayout(&value));

    EXPECT_EQ(::nn::settings::KeyboardLayout_ChineseSimplified, value);

    ::nn::settings::SetApplicationOwnKeyboardLayout(
        ::nn::settings::KeyboardLayout_ChineseTraditional);

    value = ::nn::settings::KeyboardLayout();

    EXPECT_TRUE(
        ::nn::settings::system::GetApplicationOwnKeyboardLayout(&value));

    EXPECT_EQ(::nn::settings::KeyboardLayout_ChineseTraditional, value);
}
