﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Assert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>

#include "testSettings_FileSystem.h"
#include "testSettings_Utility.h"

namespace nnt { namespace settings { namespace fwdbg {

void InitializeTestEnvironment() NN_NOEXCEPT
{
    ::nnt::settings::fwdbg::MountFileSystem();
}

void InitializeSettings() NN_NOEXCEPT
{
    ::nnt::settings::fwdbg::InitializeSettingsRootDirectory();
}

void CreateSettings(const char* name) NN_NOEXCEPT
{
    NN_ASSERT_NOT_NULL(name);
    ::nnt::settings::fwdbg::CreateSettingsDirectory(name);
}

void CreateSettingsItem(const char* name,
                        const char* key,
                        const void* value,
                        size_t size) NN_NOEXCEPT
{
    NN_ASSERT_NOT_NULL(name);
    NN_ASSERT_NOT_NULL(key);
    NN_ASSERT_NOT_NULL(value);
    ::nnt::settings::fwdbg::CreateSettingsItemFile(name, key, value, size);
}

}}} // namespace nnt::settings::fwdbg
