﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "Util.h"

static const int GcMemoryPageSizeForAccessPattern = 512;
static const int KeyAreaPageSize = 0x08;
static const int DefaultReservedAreaStartPageAddress = 0x1dc000;

class AccessPatternManager
{
private:
    uint64_t m_ReservedAreaStartPageAddress;
    AccessPatternManager()
    {
        m_ReservedAreaStartPageAddress = 32 * DefaultReservedAreaStartPageAddress;
    }
public:
    static AccessPatternManager &GetInstance()
    {
        static AccessPatternManager accessPatternManager;
        return accessPatternManager;
    }
    void GetAccessPattern(char* pOutBuffer, u32 pageAddress, u32 pageSize);
    bool CompAccessPattern(char* pInBuffer, u32 pageAddress, u32 pageSize);
    void SetCardSize(u32 cardSize);
};
