﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/dd.h>
#include <nn/sdmmc/sdmmc_Common.h>

nn::dd::DeviceVirtualAddress MapDeviceAddressSpaceAligned(nn::dd::DeviceAddressSpaceType* pDas, nn::dd::DeviceAddressSpaceMapInfo* pInfo,
    uintptr_t alignedBufferAddress, size_t alignedBufferSize, nn::dd::DeviceVirtualAddress deviceVirtualAddressOffset) NN_NOEXCEPT;
void UnmapDeviceAddressSpaceAligned(nn::dd::DeviceAddressSpaceMapInfo* pInfo) NN_NOEXCEPT;
void SetupDeviceAddressSpace(nn::dd::DeviceAddressSpaceType* pDas, nn::dd::DeviceName deviceName) NN_NOEXCEPT;
void CleanDeviceAddressSpace(nn::dd::DeviceAddressSpaceType* pDas, nn::dd::DeviceName deviceName) NN_NOEXCEPT;
nn::dd::DeviceVirtualAddress MapDeviceAddressSpaceAligned(nn::dd::DeviceAddressSpaceType* pDas,
    uintptr_t alignedBufferAddress, size_t alignedBufferSize, nn::dd::DeviceVirtualAddress deviceVirtualAddressOffset) NN_NOEXCEPT;
void UnmapDeviceAddressSpaceAligned(nn::dd::DeviceAddressSpaceType* pDas,
    uintptr_t alignedBufferAddress, size_t alignedBufferSize, nn::dd::DeviceVirtualAddress deviceVirtualAddress) NN_NOEXCEPT;

void LogBusStatus(nn::sdmmc::Port port) NN_NOEXCEPT;
