﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/helloworld.h>
#include <nn/nn_SdkText.h>

//-----------------------------------------------------------------------------
// テストケース HelloWorldStringTest
//
// 各言語の "Hello, World!" 相当の文字列を取得し、その内容を確認します
//-----------------------------------------------------------------------------
TEST(HelloWorldStringTest, GetHelloWorldString)
{
    EXPECT_STREQ(
        "Hello, World!",
        nn::helloworld::GetHelloWorldString()
    );
}

TEST(HelloWorldStringTest, GetTranslatedHelloWorldString)
{
    EXPECT_STREQ(
        "Hello, World!",
        nn::helloworld::GetTranslatedHelloWorldString(nn::helloworld::Language::English)
    );
    EXPECT_STREQ(
        "Hallo, Welt!",
        nn::helloworld::GetTranslatedHelloWorldString(nn::helloworld::Language::German)
    );
    EXPECT_STREQ(
        "Bonjour Tout Le Monde!",
        nn::helloworld::GetTranslatedHelloWorldString(nn::helloworld::Language::French)
    );
    {
        // EXPECT_STREQ マクロ内に直接書くと英語環境の VC のビルドで C4566 の警告が発生する
        // 文字列をマクロ外で定義することで回避する
        auto const expected = NN_TEXT("こんにちは、世界！");
        EXPECT_STREQ(
            expected,
            nn::helloworld::GetTranslatedHelloWorldString(nn::helloworld::Language::Japanese)
        );
    }
}


//-----------------------------------------------------------------------------
// テストケース PreConditionViolationTest
//
// 事前条件を満たしていない関数呼び出しを行い、適切な対応が取られるかどうか
// 確認します
//-----------------------------------------------------------------------------
TEST(PreConditionViolationTest, GetTranslatedHelloWorldString)
{
    EXPECT_EQ(
        nullptr,
        nn::helloworld::GetTranslatedHelloWorldString(static_cast<nn::helloworld::Language>(-1))
    );
}
