﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

class PkiResources
{
public:
    // -----------------------------------------------------------------------------
    // Constants
    // -----------------------------------------------------------------------------
    static const int ServerCertCount = 6;

    static const char ServerCert1[];
    static const char ServerCert2[];
    static const char ServerCert3[];
    static const char ServerCert4[];
    static const char ServerCert5[];
    static const char ServerCert6[];

    class ClientPki1
    {
    public:
        static const unsigned int  PasswordLength = 4;
        static const unsigned int  DataSize       = 2605;
        static const char          Password[];
        static const unsigned char Data[];
    };

    class ClientPki2
    {
    public:
        static const unsigned int  PasswordLength = 4;
        static const unsigned int  DataSize       = 1845;
        static const char          Password[];
        static const unsigned char Data[];
    };

    // -----------------------------------------------------------------------------
    // Public methods
    // -----------------------------------------------------------------------------
    PkiResources()
    {
        m_pServerPkis[0] = ServerCert1;
        m_pServerPkis[1] = ServerCert2;
        m_pServerPkis[2] = ServerCert3;
        m_pServerPkis[3] = ServerCert4;
        m_pServerPkis[4] = ServerCert5;
        m_pServerPkis[5] = ServerCert6;
    }

    const char* GetServerCertPointer(int index)
    {
        return m_pServerPkis[index];
    }

private:
    const char* m_pServerPkis[ServerCertCount];
};
