﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "ExecuterTestsBase.h"

// ------------------------------------------------------------------------------------------------
// ExecuterTestsRunWithSingleHost
// ------------------------------------------------------------------------------------------------
class ExecuterTestsRunWithSingleHost : public ExecuterTestsBase
{
    uint32_t                              m_RunCount;
    char                                  m_HostName[128];
    uint16_t                              m_Port;
    nn::ssl::Connection::VerifyOption     m_VerifyOption;
    nn::ssl::Connection::SessionCacheMode m_SessionCacheMode;

public:
    ExecuterTestsRunWithSingleHost(
        const char* pInHostName,
        nn::ssl::Connection::VerifyOption verifyOption,
        nn::ssl::Connection::SessionCacheMode sessionCacheMode,
        uint16_t port,
        uint32_t count);
    ~ExecuterTestsRunWithSingleHost();
    void Run();
};

