﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ro.h>

namespace nn { namespace mem {
class StandardAllocator;
}} // namespace nn::mem

static const size_t DefaultAlign = 0x1000;
static const size_t MaxFileSize  = 0x400000;
static const char* NrrName = ".nrr/TestRoModule.nrr";

class TestNro
{
public:
    TestNro() NN_NOEXCEPT;
    TestNro(const char* name, nn::mem::StandardAllocator* allocator) NN_NOEXCEPT;
    ~TestNro() NN_NOEXCEPT;

    void SetUp(const char* name, nn::mem::StandardAllocator* allocator) NN_NOEXCEPT;
    nn::Result Load(int flag, const char* nrrName = nullptr) NN_NOEXCEPT;
    void Unload() NN_NOEXCEPT;
    nn::Result FindSymbol(uintptr_t* pOutValue, const char* name) const NN_NOEXCEPT;
    nn::ro::Module* GetModule() NN_NOEXCEPT { return &m_Module; }

private:
    const char* m_Name;
    void* m_Nro;
    void* m_Bss;
    void* m_Nrr;
    size_t m_ImageSize;
    size_t m_BufferSize;
    size_t m_NrrSize;
    nn::mem::StandardAllocator* m_Allocator;
    nn::ro::Module m_Module;
    nn::ro::RegistrationInfo m_Info;
};

