﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "util_Common.h"
#include <nn/ro/ro_Api.h>
#include <nn/ro/ro_Result.h>

namespace {
    const char* BinDefineExternName = "nro/BinDefineExtern.nro";
    typedef int (*ReturnInt)();

    const char* ExternalFunctionName = "_Z16ExternalFunctionv";
    const char* ExternalValueName = "g_ExternValue";

    TestNro g_Nro;
}

void TestLoadOtherDll(nn::ro::BindFlag flag)
{
    TestAllocator& allocator = TestAllocator::GetInstance();
    g_Nro.SetUp(BinDefineExternName, allocator.GetAllocator());
    auto result = g_Nro.Load(flag);
    NN_ASSERT_RESULT_SUCCESS(result);

    uintptr_t addr = 0;

    result = nn::ro::LookupSymbol(&addr, ExternalFunctionName);
    NN_ASSERT_RESULT_SUCCESS(result);

    ReturnInt func = reinterpret_cast<ReturnInt>(addr);
    NN_ASSERT_EQUAL(func(), 10);

    result = nn::ro::LookupSymbol(&addr, ExternalValueName);
    NN_ASSERT_RESULT_SUCCESS(result);
    int* ptr = reinterpret_cast<int*>(addr);
    NN_ASSERT_EQUAL(*ptr, 10);

    result = g_Nro.FindSymbol(&addr, ExternalFunctionName);
    NN_ASSERT_RESULT_SUCCESS(result);
    NN_ASSERT_EQUAL(addr, reinterpret_cast<uintptr_t>(func));
}

void UnloadOtherDll()
{
    g_Nro.Unload();
}
