﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nnc/nn_Result.h>
#include <nnc/result/result_CConverter.h>

#include <nnt/nntest.h>
#include <type_traits>
#include <cstdint>
#include <nn/nn_Abort.h>

#include <nn/nn_ErrorResult.h>

namespace nnt { namespace foo {

    NN_DEFINE_ABSTRACT_ERROR_RANGE_RESULT(ResultAll, 10, 0, 300);
        NN_DEFINE_ABSTRACT_ERROR_RANGE_RESULT(ResultA, 10, 0, 100);
            NN_DEFINE_ERROR_RANGE_RESULT(ResultA1, 10, 1, 2);
            NN_DEFINE_ERROR_RANGE_RESULT(ResultA2, 10, 2, 3);
        NN_DEFINE_ERROR_RANGE_RESULT(ResultB, 10, 100, 200);
            NN_DEFINE_ERROR_RANGE_RESULT(ResultB1, 10, 101, 102);
        NN_DEFINE_ERROR_RANGE_RESULT(ResultC, 10, 200, 300);
    NN_DEFINE_ERROR_RANGE_RESULT(ResultOther, 20, 0, 500);

    NN_DEFINE_ERROR_RANGE_RESULT(ResultModuleMax, 511, 0, 1);
    NN_DEFINE_ERROR_RANGE_RESULT(ResultDescriptionMax, 1, 8191, 8192);

}}

#undef NN_DEFINE_ERROR_RANGE_RESULT
#undef NN_DEFINE_ABSTRACT_ERROR_RANGE_RESULT

#include <nnc/nn_ErrorResult.h>

#define NN_DEFINE_ERROR_RANGE_RESULT_PREFIX nntfoo

    NN_DEFINE_ABSTRACT_ERROR_RANGE_RESULT(ResultAll, 10, 0, 300)
        NN_DEFINE_ABSTRACT_ERROR_RANGE_RESULT(ResultA, 10, 0, 100)
            NN_DEFINE_ERROR_RANGE_RESULT(ResultA1, 10, 1, 2)
            NN_DEFINE_ERROR_RANGE_RESULT(ResultA2, 10, 2, 3)
        NN_DEFINE_ERROR_RANGE_RESULT(ResultB, 10, 100, 200)
            NN_DEFINE_ERROR_RANGE_RESULT(ResultB1, 10, 101, 102)
        NN_DEFINE_ERROR_RANGE_RESULT(ResultC, 10, 200, 300)
    NN_DEFINE_ERROR_RANGE_RESULT(ResultOther, 20, 0, 500)

    NN_DEFINE_ERROR_RANGE_RESULT(ResultModuleMax, 511, 0, 1)
    NN_DEFINE_ERROR_RANGE_RESULT(ResultDescriptionMax, 1, 8191, 8192)

#undef NN_DEFINE_ERROR_RANGE_RESULT_PREFIX

// 複数の NN_DEFINE_ERROR_RANGE_RESULT_PREFIX を使用できることの確認
#define NN_DEFINE_ERROR_RANGE_RESULT_PREFIX nntbar

    NN_DEFINE_ABSTRACT_ERROR_RANGE_RESULT(ResultAll, 11, 0, 300)

#undef NN_DEFINE_ERROR_RANGE_RESULT_GET_PREFIX

TEST(result, C_Success)
{
    {
        auto cResult = nnResultSuccess();
        ASSERT_TRUE(nnResultGetModule(cResult) == 0);
        ASSERT_TRUE(nnResultGetDescription(cResult) == 0);
        ASSERT_TRUE(nnResultIsSuccess(cResult));
        ASSERT_TRUE(!nnResultIsFailure(cResult));
    }
}

TEST(result, C_Construct)
{
    {
        auto cResult = nntfooMakeResultA1();
        ASSERT_TRUE(nnResultGetModule(cResult) == 10);
        ASSERT_TRUE(nnResultGetDescription(cResult) == 1);
        ASSERT_TRUE(!nnResultIsSuccess(cResult));
        ASSERT_TRUE(nnResultIsFailure(cResult));
    }
}

TEST(result, C_Includes)
{
    {
        auto cResult = nntfooMakeResultA1();
        ASSERT_TRUE(nntfooResultAllIncludes(cResult));
        ASSERT_TRUE(nntfooResultAIncludes(cResult));
        ASSERT_TRUE(nntfooResultA1Includes(cResult));
    }
}

TEST(result, C_Convert)
{
    {
        auto cResult = nntfooMakeResultA1();
        auto result = nn::result::ConvertFromC(cResult);
        ASSERT_TRUE(result.GetModule() == 10);
        ASSERT_TRUE(result.GetDescription() == 1);
    }
    {
        nn::Result result = nnt::foo::ResultA1();
        auto cResult = nn::result::ConvertToC(result);
        ASSERT_TRUE(nnResultGetModule(cResult) == 10);
        ASSERT_TRUE(nnResultGetDescription(cResult) == 1);
    }
}

TEST(result, C_ConvertSuccess)
{
    {
        auto cResult = nnResultSuccess();
        auto result = nn::result::ConvertFromC(cResult);
        ASSERT_TRUE(result.GetModule() == 0);
        ASSERT_TRUE(result.GetDescription() == 0);
        ASSERT_TRUE(result.IsSuccess());
    }
    {
        nn::Result result = nn::ResultSuccess();
        auto cResult = nn::result::ConvertToC(result);
        ASSERT_TRUE(nnResultGetModule(cResult) == 0);
        ASSERT_TRUE(nnResultGetDescription(cResult) == 0);
        ASSERT_TRUE(nnResultIsSuccess(cResult));
    }
}
