﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nnt { namespace psm { namespace driver { namespace detail {

void SetBatteryTemperature(double temperature) NN_NOEXCEPT;

void SetBatteryChargePercentage(double batteryChargePercentage) NN_NOEXCEPT;

void SetAverageCurrentMilliAmpere(int averageCurrentMilliAmpere) NN_NOEXCEPT;

void SetVoltageFuelGaugePercentage(double voltageFuelGaugePercentage) NN_NOEXCEPT;

void SignalBatteryTemperatureTooLow() NN_NOEXCEPT;

void SignalBatteryTemperatureTooHigh() NN_NOEXCEPT;

void SetBatteryVoltageMilliVolt(int milliVolt) NN_NOEXCEPT;

void SignalBatteryVoltageTooLow() NN_NOEXCEPT;

void SignalBatteryVoltageTooHigh() NN_NOEXCEPT;

}}}} // namespace nnt::psm::driver::detail
