﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <cstdlib>

#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/init.h>
#include <nn/os/os_Argument.h>
#include <nn/profiler.h>

#include "../../Common/testProfiler_Common.h"

namespace /*anonymous*/ {

    NN_ALIGNAS(4096) char g_mallocBuffer[1024 * 1024];

    volatile int g_value;

    NN_NOINLINE void BusyWork();

    void BusyWork()
    {
        int r = rand() & INT16_MAX;
        for (int i = 0; i < r; ++i)
        {
            g_value ^= (g_value << 24) + (g_value * i);
        }
    }

} // anonymous


extern "C" void nninitStartup()
{
    nn::init::InitializeAllocator(g_mallocBuffer, sizeof(g_mallocBuffer));
}


extern "C" void nnMain()
{
    while (NN_STATIC_CONDITION(true))
    {
        BusyWork();
        nn::os::SleepThread(nn::TimeSpan::FromMicroSeconds(100));
    }
}
