﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>

#include <nn/nn_Common.h>
#include <nn/fs.h>
#include <nn/nifm.h>
#include <nn/nifm/nifm_ApiForMenu.h>
#include <nn/nifm/nifm_ApiForSystem.h>
#include <nn/nifm/nifm_NetworkConnection.h>
#include <nn/socket.h>

#include <nn/prepo/detail/service/core/prepo_DeviceAuthenticationToken.h>
#include <nn/prepo/detail/service/core/prepo_ReportUploader.h>

#include "../Common/testPrepo_Common.h"

namespace
{
    nn::socket::ConfigDefaultWithMemory g_SocketConfigWithMemory;
}

TEST(Upload, Basic)
{
    nn::socket::Initialize(g_SocketConfigWithMemory);

    NN_UTIL_SCOPE_EXIT
    {
        nn::socket::Finalize();
    };

    NNT_ASSERT_RESULT_SUCCESS(nn::nifm::InitializeSystem());

    nn::nifm::NetworkConnection nc;

    NNT_ASSERT_RESULT_SUCCESS(nn::nifm::SetRequestRequirementPreset(nc.GetRequestHandle(),
        nn::nifm::RequirementPreset_InternetForSystemProcessSharable));

    nc.SubmitRequestAndWait();

    ASSERT_TRUE(nc.IsAvailable());

    const char* authToken = nullptr;

    NNT_ASSERT_RESULT_SUCCESS(nn::prepo::detail::service::core::DeviceAuthenticationToken::GetInstance().Get(&authToken, false));

    NN_FUNCTION_LOCAL_STATIC(nn::Bit8, s_MountRomCacheBuffer[4096]);

    NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountRom("rom", s_MountRomCacheBuffer, sizeof (s_MountRomCacheBuffer)));

    NN_UTIL_SCOPE_EXIT
    {
        nn::fs::Unmount("rom");
    };

    NN_FUNCTION_LOCAL_STATIC(nn::Bit8, s_ReportFileBuffer[nn::prepo::detail::ReportFileSizeMax]);

    size_t readSize;
    NNT_ASSERT_RESULT_SUCCESS(nnt::prepo::ReadFile(&readSize, "rom:/post.msgpack", s_ReportFileBuffer, sizeof (s_ReportFileBuffer)));

    NNT_ASSERT_RESULT_SUCCESS(nn::prepo::detail::service::core::ReportUploader::GetInstance().Upload(authToken, s_ReportFileBuffer, readSize));
}
