<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Create Nsp

    .DESCRIPTION
        Create Nsp
#>

[CmdletBinding()]
Param(
    [parameter(Mandatory=$true)]
    [string]$PreinstallVersion = "",

    [parameter(Mandatory=$true)]
    [string]$OutputDirectory = "",

    [parameter(Mandatory=$true)]
    [string]$Target = ""
)

$ErrorActionPreference = "Stop"

$scriptPath = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [IO.Path]::GetDirectoryName($ScriptPath)
$sigloRoot = (Join-Path $scriptDirectoryPath ../../.. | Resolve-Path).Path
$moduleRoot = "${sigloRoot}\Integrate\Scripts\Modules\"

Import-Module "${moduleRoot}\Path"
Import-Module "${moduleRoot}\Utility"

$RunOnTarget = "$sigloRoot/Tools/CommandLineTools/RunOnTarget.exe"
$CalWriter = "$sigloRoot/Programs/Eris/Outputs/NX-NXFP2-a64/TargetTools/CalWriter/Develop/CalWriter.nsp"

# ディレクトリ作成
Invoke-CriticalCommand "& $RunOnTarget --target $Target $CalWriter --  MakeDirectory cal:/ptd"
Invoke-CriticalCommand "& $RunOnTarget --target $Target $CalWriter --  MakeDirectory cal:/ptd/log"

$PreinstallVersion | Set-Content "$OutputDirectory/PreinstallVersion.txt"

Invoke-CriticalCommand "& $RunOnTarget --target $Target $CalWriter --  PutFile $OutputDirectory/PreinstallVersion.txt cal:/ptd/log/PreinstallVer_Finalize.log"
