﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>

#include <nn/result/result_HandlingUtility.h>

namespace nn { namespace idle {

nn::os::SystemEventType g_AutoPowerDownEvent;

void InitializeForSystem() NN_NOEXCEPT
{
    nn::os::CreateSystemEvent(&g_AutoPowerDownEvent, nn::os::EventClearMode_ManualClear, true);
}

nn::Result GetAutoPowerDownEvent(nn::os::SystemEventType* pOutSystemEvent, nn::os::EventClearMode clearMode) NN_NOEXCEPT
{
    nn::os::AttachReadableHandleToSystemEvent(pOutSystemEvent,
        nn::os::GetReadableHandleOfSystemEvent(&g_AutoPowerDownEvent), false, clearMode);

    NN_RESULT_SUCCESS;
}

void SignalAutoPowerDownEvent() NN_NOEXCEPT
{
    nn::os::SignalSystemEvent(&g_AutoPowerDownEvent);
}

void FinalizeForSystem() NN_NOEXCEPT
{
    nn::os::DestroySystemEvent(&g_AutoPowerDownEvent);
}

}} // namespace nn::idle
