﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <vector>
#include <nn/nn_Common.h>
#include <nn/nn_Assert.h>

#include <nn/result/result_HandlingUtility.h>
#include <nn/gpio/gpio.h>

namespace {
    bool g_WakeEventFlags[128] = { false };
}

namespace nn { namespace gpio {

void Initialize() NN_NOEXCEPT
{
    for ( auto& wakeEvent : g_WakeEventFlags )
    {
        wakeEvent = false;
    }
}

void Finalize() NN_NOEXCEPT
{
}

bool IsWakeEventActive(GpioPadName name) NN_NOEXCEPT
{
    NN_ASSERT_RANGE(name, 0, NN_ARRAY_SIZE(g_WakeEventFlags));
    return g_WakeEventFlags[name];
}

}} // namespace nn::gpio

// 以下テスト環境専用

namespace nnt { namespace gpio {

void SetWakeEventActiveFlag(const std::vector<nn::gpio::GpioPadName>& padList) NN_NOEXCEPT
{
    for ( auto& wakeEvent : g_WakeEventFlags )
    {
        wakeEvent = false;
    }
    for ( auto& pad : padList )
    {
        NN_ASSERT_RANGE(pad, 0, NN_ARRAY_SIZE(g_WakeEventFlags));
        g_WakeEventFlags[pad] = true;
    }
}

}} // namespace nnt::gpio
